/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.internal.BaseView;
import org.jclouds.location.Provider;
import org.jclouds.rest.Utils;
import org.jclouds.util.Closeables2;

@Singleton
public class BlobStoreContextImpl
extends BaseView
implements BlobStoreContext {
    private final BlobStore blobStore;
    private final ConsistencyModel consistencyModel;
    private final Utils utils;
    private final BlobRequestSigner blobRequestSigner;

    @Inject
    public BlobStoreContextImpl(@Provider Context backend, @Provider TypeToken<? extends Context> backendType, Utils utils, ConsistencyModel consistencyModel, BlobStore blobStore, BlobRequestSigner blobRequestSigner) {
        super(backend, backendType);
        this.consistencyModel = Preconditions.checkNotNull(consistencyModel, "consistencyModel");
        this.blobStore = Preconditions.checkNotNull(blobStore, "blobStore");
        this.utils = Preconditions.checkNotNull(utils, "utils");
        this.blobRequestSigner = Preconditions.checkNotNull(blobRequestSigner, "blobRequestSigner");
    }

    @Override
    public ConsistencyModel getConsistencyModel() {
        return this.consistencyModel;
    }

    @Override
    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    @Override
    public BlobRequestSigner getSigner() {
        return this.blobRequestSigner;
    }

    @Override
    public void close() {
        Closeables2.closeQuietly(this.delegate());
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    public String toString() {
        return this.delegate().toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }
}

