/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;

public final class JcloudsBlobStoreHelper {
    private JcloudsBlobStoreHelper() {
    }

    public static void mkDirs(BlobStore blobStore, String container, String blobName) {
        if (blobStore != null && !Strings.isNullOrEmpty(blobName) && blobName.contains("/")) {
            String directory = BlobStoreUtils.parseDirectoryFromPath(blobName);
            blobStore.createDirectory(container, directory);
        }
    }

    public static void ensureContainerExists(BlobStore blobStore, String container, String locationId) {
        if (blobStore != null && !Strings.isNullOrEmpty(container) && !blobStore.containerExists(container)) {
            blobStore.createContainerInLocation(JcloudsBlobStoreHelper.getLocationById(blobStore, locationId), container);
        }
    }

    public static Location getLocationById(BlobStore blobStore, String locationId) {
        if (blobStore != null && !Strings.isNullOrEmpty(locationId)) {
            for (Location location : blobStore.listAssignableLocations()) {
                if (!locationId.equals(location.getId())) continue;
                return location;
            }
        }
        return null;
    }

    public static void writeBlob(BlobStore blobStore, String container, String blobName, Payload payload) {
        if (blobName != null && payload != null) {
            JcloudsBlobStoreHelper.mkDirs(blobStore, container, blobName);
            Blob blob = blobStore.blobBuilder(blobName).payload(payload).contentType("application/octet-stream").contentDisposition(blobName).build();
            blobStore.putBlob(container, blob, PutOptions.Builder.multipart());
        }
    }

    public static InputStream readBlob(BlobStore blobStore, String container, String blobName) throws IOException {
        Blob blob;
        InputStream is = null;
        if (!Strings.isNullOrEmpty(blobName) && (blob = blobStore.getBlob(container, blobName)) != null && blob.getPayload() != null) {
            is = blobStore.getBlob(container, blobName).getPayload().openStream();
        }
        return is;
    }

    public static long countBlob(BlobStore blobStore, String container) {
        long blobsCount = blobStore.countBlobs(container);
        return blobsCount;
    }

    public static void removeBlob(BlobStore blobStore, String container, String blobName) {
        if (!Strings.isNullOrEmpty(blobName)) {
            blobStore.removeBlob(container, blobName);
        }
    }

    public static void clearContainer(BlobStore blobStore, String container) {
        blobStore.clearContainer(container);
    }

    public static void deleteContainer(BlobStore blobStore, String container) {
        blobStore.deleteContainer(container);
    }

    public static boolean containerExists(BlobStore blobStore, String container) {
        boolean result = blobStore.containerExists(container);
        return result;
    }

    public static void removeBlobs(BlobStore blobStore, String container, List blobNames) {
        blobStore.removeBlobs(container, blobNames);
    }
}

