/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Converter(generateBulkLoader=true)
public final class DomConverter {
    private final XmlConverter xml = new XmlConverter();

    @Converter(order=1)
    public String toString(NodeList nodeList, Exchange exchange) throws TransformerException {
        StringBuilder buffer = new StringBuilder();
        boolean found = false;
        if (nodeList instanceof Node) {
            Node node = (Node)((Object)nodeList);
            String s = this.toString(node, exchange);
            if (ObjectHelper.isNotEmpty(s)) {
                found = true;
                buffer.append(s);
            }
        } else {
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = nodeList.item(i);
                String s = this.toString(node, exchange);
                if (!ObjectHelper.isNotEmpty(s)) continue;
                found = true;
                buffer.append(s);
            }
        }
        if (!found) {
            DomConverter.append(buffer, nodeList);
        }
        return buffer.toString();
    }

    @Converter(order=2)
    public String toString(Node node, Exchange exchange) throws TransformerException {
        String s;
        if (node instanceof Text) {
            Text textnode = (Text)node;
            StringBuilder b = new StringBuilder();
            b.append(textnode.getNodeValue());
            for (textnode = (Text)textnode.getNextSibling(); textnode != null; textnode = (Text)textnode.getNextSibling()) {
                b.append(textnode.getNodeValue());
            }
            s = b.toString();
        } else {
            s = this.xml.toString(new DOMSource(node), exchange);
        }
        return s;
    }

    @Converter(order=3)
    public static Integer toInteger(NodeList nodeList) {
        StringBuilder buffer = new StringBuilder();
        DomConverter.append(buffer, nodeList);
        String s = buffer.toString();
        return Integer.valueOf(s);
    }

    @Converter(order=4)
    public static Long toLong(NodeList nodeList) {
        StringBuilder buffer = new StringBuilder();
        DomConverter.append(buffer, nodeList);
        String s = buffer.toString();
        return Long.valueOf(s);
    }

    @Converter(order=5)
    public static List<?> toList(NodeList nodeList) {
        ArrayList answer = new ArrayList();
        Iterator<?> it = org.apache.camel.support.ObjectHelper.createIterator(nodeList);
        while (it.hasNext()) {
            answer.add(it.next());
        }
        return answer;
    }

    @Converter(order=6)
    public InputStream toInputStream(NodeList nodeList, Exchange exchange) throws TransformerException, UnsupportedEncodingException {
        return new ByteArrayInputStream(this.toByteArray(nodeList, exchange));
    }

    @Converter(order=7)
    public byte[] toByteArray(NodeList nodeList, Exchange exchange) throws TransformerException, UnsupportedEncodingException {
        String data = this.toString(nodeList, exchange);
        return data.getBytes(ExchangeHelper.getCharset(exchange));
    }

    private static void append(StringBuilder buffer, NodeList nodeList) {
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            DomConverter.append(buffer, nodeList.item(i));
        }
    }

    private static void append(StringBuilder buffer, Node node) {
        if (node instanceof Text) {
            Text text = (Text)node;
            buffer.append(text.getTextContent());
        } else if (node instanceof Attr) {
            Attr attribute = (Attr)node;
            buffer.append(attribute.getTextContent());
        } else if (node instanceof Element) {
            Element element = (Element)node;
            DomConverter.append(buffer, element.getChildNodes());
        }
    }
}

