/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(CatchProcessor.class);
    private String id;
    private String routeId;
    private final List<Class<? extends Throwable>> exceptions;
    private final Predicate onWhen;

    public CatchProcessor(List<Class<? extends Throwable>> exceptions, Processor processor, Predicate onWhen) {
        super(processor);
        this.exceptions = exceptions;
        this.onWhen = onWhen;
    }

    @Override
    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public String getTraceLabel() {
        return "catch";
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final Exception e = exchange.getException();
        Throwable caught = this.catches(exchange, e);
        if (exchange.getProperty(ExchangePropertyKey.EXCEPTION_HANDLED) != null || caught == null) {
            callback.done(true);
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("This CatchProcessor catches the exception: {} caused by: {}", (Object)caught.getClass().getName(), (Object)e.getMessage());
        }
        ExtendedExchange ee = (ExtendedExchange)exchange;
        final boolean stop = ee.isRouteStop();
        ee.setRouteStop(false);
        final boolean rollbackOnly = ee.isRollbackOnly();
        ee.setRollbackOnly(false);
        final boolean rollbackOnlyLast = ee.isRollbackOnlyLast();
        ee.setRollbackOnlyLast(false);
        if (exchange.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT) == null) {
            exchange.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, exchange.getProperty(ExchangePropertyKey.TO_ENDPOINT));
        }
        exchange.setProperty(ExchangePropertyKey.EXCEPTION_HANDLED, (Object)true);
        exchange.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)e);
        exchange.setException(null);
        exchange.adapt(ExtendedExchange.class).setRedeliveryExhausted(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("The exception is handled for the exception: {} caused by: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
        EventHelper.notifyExchangeFailureHandling(exchange.getContext(), exchange, this.processor, false, null);
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                EventHelper.notifyExchangeFailureHandled(exchange.getContext(), exchange, CatchProcessor.this.processor, false, null);
                exchange.adapt(ExtendedExchange.class).setRedeliveryExhausted(false);
                if (rollbackOnly || rollbackOnlyLast || stop) {
                    exchange.setRouteStop(stop);
                    exchange.setRollbackOnly(rollbackOnly);
                    exchange.setRollbackOnlyLast(rollbackOnlyLast);
                    if (e instanceof RollbackExchangeException) {
                        exchange.setException(e);
                    }
                }
                if (!doneSync) {
                    ExchangeHelper.prepareOutToIn(exchange);
                }
                callback.done(doneSync);
            }
        });
        return sync;
    }

    protected Throwable catches(Exchange exchange, Throwable exception) {
        for (Throwable e : ObjectHelper.createExceptionIterable(exception)) {
            for (Class<? extends Throwable> type : this.exceptions) {
                if (!type.isInstance(e) || !this.matchesWhen(exchange)) continue;
                return e;
            }
        }
        return null;
    }

    public List<Class<? extends Throwable>> getExceptions() {
        return this.exceptions;
    }

    protected boolean matchesWhen(Exchange exchange) {
        if (this.onWhen == null) {
            return true;
        }
        return this.onWhen.matches(exchange);
    }
}

