/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.jclouds.compute.domain.ComputeMetadataIncludingStatus;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.logging.Logger;

public abstract class RefreshAndDoubleCheckOnFailUnlessStatusInvalid<S extends Enum<S>, C extends ComputeMetadataIncludingStatus<S>>
implements Predicate<AtomicReference<C>> {
    private final S intended;
    private final Set<S> invalids;
    @Resource
    protected Logger logger = Logger.NULL;

    public RefreshAndDoubleCheckOnFailUnlessStatusInvalid(S intended, Set<S> invalids) {
        this.intended = (Enum)Preconditions.checkNotNull(intended, "intended");
        this.invalids = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(invalids, "invalids"));
    }

    @Override
    public boolean apply(AtomicReference<C> atomicResource) {
        ComputeMetadataIncludingStatus resource = (ComputeMetadataIncludingStatus)atomicResource.get();
        if (this.checkStatus(resource)) {
            return true;
        }
        resource = this.refreshOrNull(resource);
        atomicResource.set(resource);
        return this.checkStatus(resource);
    }

    public boolean checkStatus(C resource) {
        if (resource == null) {
            return false;
        }
        this.logger.trace("%s: looking for resource state %s: currently: %s", resource.getId(), this.intended, ComputeServiceUtils.formatStatus(resource));
        if (this.invalids.contains(resource.getStatus())) {
            throw new IllegalStateException("resource " + resource.getId() + " in location " + resource.getLocation() + " is in invalid status " + ComputeServiceUtils.formatStatus(resource));
        }
        return resource.getStatus() == this.intended;
    }

    protected abstract C refreshOrNull(C var1);
}

