/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.stub.config;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.net.HostAndPort;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.stub.extensions.StubSecurityGroupExtension;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;
import org.jclouds.predicates.SocketOpen;

public class StubComputeServiceDependenciesModule
extends AbstractModule {
    protected static final LoadingCache<String, ConcurrentMap<String, NodeMetadata>> backing = CacheBuilder.newBuilder().build(new CacheLoader<String, ConcurrentMap<String, NodeMetadata>>(){

        @Override
        public ConcurrentMap<String, NodeMetadata> load(String arg0) throws Exception {
            return new ConcurrentHashMap<String, NodeMetadata>();
        }
    });
    protected static final LoadingCache<String, ConcurrentMap<String, SecurityGroup>> groupBacking = CacheBuilder.newBuilder().build(new CacheLoader<String, ConcurrentMap<String, SecurityGroup>>(){

        @Override
        public ConcurrentMap<String, SecurityGroup> load(String arg0) throws Exception {
            return new ConcurrentHashMap<String, SecurityGroup>();
        }
    });
    protected static final LoadingCache<String, Multimap<String, SecurityGroup>> groupsForNodeBacking = CacheBuilder.newBuilder().build(new CacheLoader<String, Multimap<String, SecurityGroup>>(){

        @Override
        public Multimap<String, SecurityGroup> load(String arg0) throws Exception {
            return LinkedHashMultimap.create();
        }
    });
    protected static final LoadingCache<String, AtomicInteger> nodeIds = CacheBuilder.newBuilder().build(new CacheLoader<String, AtomicInteger>(){

        @Override
        public AtomicInteger load(String arg0) throws Exception {
            return new AtomicInteger(0);
        }
    });
    protected static final LoadingCache<String, AtomicInteger> groupIds = CacheBuilder.newBuilder().build(new CacheLoader<String, AtomicInteger>(){

        @Override
        public AtomicInteger load(String arg0) throws Exception {
            return new AtomicInteger(0);
        }
    });

    @Override
    protected void configure() {
        this.bind(new TypeLiteral<SecurityGroupExtension>(){}).to(StubSecurityGroupExtension.class);
    }

    @Provides
    @Singleton
    protected final ConcurrentMap<String, NodeMetadata> provideNodesForIdentity(@Provider Supplier<Credentials> creds) throws ExecutionException {
        return backing.get(creds.get().identity);
    }

    @Provides
    @Singleton
    protected final ConcurrentMap<String, SecurityGroup> provideGroups(@Provider Supplier<Credentials> creds) throws ExecutionException {
        return groupBacking.get(creds.get().identity);
    }

    @Provides
    @Singleton
    protected final Multimap<String, SecurityGroup> provideGroupsForNode(@Provider Supplier<Credentials> creds) throws ExecutionException {
        return groupsForNodeBacking.get(creds.get().identity);
    }

    @Provides
    @Named(value="NODE_ID")
    protected final Integer provideNodeIdForIdentity(@Provider Supplier<Credentials> creds) throws ExecutionException {
        return nodeIds.get(creds.get().identity).incrementAndGet();
    }

    @Provides
    @Named(value="GROUP_ID")
    protected final Integer provideGroupIdForIdentity(@Provider Supplier<Credentials> creds) throws ExecutionException {
        return groupIds.get(creds.get().identity).incrementAndGet();
    }

    @Singleton
    @Provides
    @Named(value="PUBLIC_IP_PREFIX")
    final String publicIpPrefix() {
        return "144.175.1.";
    }

    @Singleton
    @Provides
    @Named(value="PRIVATE_IP_PREFIX")
    final String privateIpPrefix() {
        return "10.1.1.";
    }

    @Singleton
    @Provides
    @Named(value="PASSWORD_PREFIX")
    final String passwordPrefix() {
        return "password";
    }

    @Singleton
    @Provides
    final SocketOpen socketOpen(StubSocketOpen in) {
        return in;
    }

    static Hardware stub(String type, int cores, int ram, float disk) {
        return new HardwareBuilder().ids(type).name(type).processors(ImmutableList.of(new Processor(cores, 1.0))).ram(ram).volumes(ImmutableList.of(new VolumeImpl(Float.valueOf(disk), true, false))).build();
    }

    @Singleton
    public static class StubSocketOpen
    implements SocketOpen {
        private final ConcurrentMap<String, NodeMetadata> nodes;
        private final String publicIpPrefix;

        @Inject
        public StubSocketOpen(ConcurrentMap<String, NodeMetadata> nodes, @Named(value="PUBLIC_IP_PREFIX") String publicIpPrefix) {
            this.nodes = nodes;
            this.publicIpPrefix = publicIpPrefix;
        }

        @Override
        public boolean apply(HostAndPort input) {
            if (input.getHost().indexOf(this.publicIpPrefix) == -1) {
                return false;
            }
            String id = input.getHost().replace(this.publicIpPrefix, "");
            NodeMetadata node = (NodeMetadata)this.nodes.get(id);
            return node != null && node.getStatus() == NodeMetadata.Status.RUNNING;
        }
    }
}

