/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import org.jclouds.http.UriTemplates;
import org.jclouds.http.utils.Queries;
import org.jclouds.http.utils.QueryValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Strings2;

@Beta
public final class Uris {
    public static UriBuilder uriBuilder(CharSequence template) {
        return new UriBuilder(template);
    }

    public static UriBuilder uriBuilder(URI uri) {
        return new UriBuilder(uri);
    }

    private static String slash(CharSequence left, CharSequence right) {
        return Uris.delimit(left, right, '/');
    }

    private static String delimit(CharSequence left, CharSequence right, char token) {
        if (left.length() == 0) {
            return right.toString();
        }
        if (right.length() == 0) {
            return left.toString();
        }
        StringBuilder builder = new StringBuilder(left);
        if (Uris.lastChar(left) == token) {
            if (Uris.firstChar(right) == token) {
                return builder.append(right.subSequence(1, right.length())).toString();
            }
            return builder.append(right).toString();
        }
        if (Uris.firstChar(right) == token) {
            return builder.append(right).toString();
        }
        return new StringBuilder(left).append(token).append(right).toString();
    }

    public static boolean lastCharIsToken(CharSequence left, char token) {
        return Uris.lastChar(left) == token;
    }

    public static char lastChar(CharSequence in) {
        return in.charAt(in.length() - 1);
    }

    public static char firstChar(CharSequence in) {
        return in.charAt(0);
    }

    public static boolean isToken(CharSequence right, char token) {
        return right.length() == 1 && right.charAt(0) == token;
    }

    private static String prefixIfNeeded(String in) {
        if (in != null && in.charAt(0) != '/') {
            return '/' + in;
        }
        return in;
    }

    private static class TransformObjectToQueryValue
    implements Function<Object, QueryValue> {
        private TransformObjectToQueryValue() {
        }

        @Override
        public QueryValue apply(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof QueryValue) {
                return (QueryValue)o;
            }
            return new QueryValue(o.toString(), false);
        }
    }

    public static final class UriBuilder {
        private static final TransformObjectToQueryValue QUERY_VALUE_TRANSFORMER = new TransformObjectToQueryValue();
        private Iterable<Character> skipPathEncoding = Lists.charactersOf("/:;=");
        private String scheme;
        private String host;
        private Integer port;
        private String path;
        private Multimap<String, Object> query = LinkedHashMultimap.create();

        public UriBuilder skipPathEncoding(Iterable<Character> skipPathEncoding) {
            this.skipPathEncoding = ImmutableSet.copyOf(Preconditions.checkNotNull(skipPathEncoding, "skipPathEncoding"));
            return this;
        }

        public UriBuilder scheme(String scheme) {
            this.scheme = Preconditions.checkNotNull(scheme, "scheme");
            return this;
        }

        public UriBuilder host(String host) {
            this.host = Preconditions.checkNotNull(host, "host");
            return this;
        }

        public UriBuilder path(@Nullable String path) {
            this.path = (path = Strings.emptyToNull(path)) == null ? null : Uris.prefixIfNeeded(Strings2.urlDecode(path));
            return this;
        }

        public UriBuilder appendPath(String path) {
            if (this.path == null) {
                this.path(path);
            } else {
                this.path(Uris.slash(this.path, path));
            }
            return this;
        }

        public UriBuilder query(@Nullable String queryLine) {
            if (this.query == null) {
                return this.clearQuery();
            }
            return this.query(Queries.queryParser().apply(queryLine));
        }

        public UriBuilder clearQuery() {
            this.query.clear();
            return this;
        }

        public UriBuilder query(Multimap<String, ?> parameters) {
            Multimap<String, QueryValue> queryValueMultimap = Multimaps.transformValues(Preconditions.checkNotNull(parameters, "parameters"), QUERY_VALUE_TRANSFORMER);
            this.query.clear();
            this.query.putAll(queryValueMultimap);
            return this;
        }

        public UriBuilder addQuery(String name, Iterable<?> values) {
            this.query.putAll(Preconditions.checkNotNull(name, "name"), Iterables.transform(Preconditions.checkNotNull(values, "values of %s", (Object)name), QUERY_VALUE_TRANSFORMER));
            return this;
        }

        public UriBuilder addQuery(String name, String ... values) {
            return this.addQuery(name, Arrays.asList(Preconditions.checkNotNull(values, "values of %s", (Object)name)));
        }

        public UriBuilder addQuery(Multimap<String, ?> parameters) {
            Multimap<String, QueryValue> queryValueMultimap = Multimaps.transformValues(Preconditions.checkNotNull(parameters, "parameters"), QUERY_VALUE_TRANSFORMER);
            this.query.putAll(queryValueMultimap);
            return this;
        }

        public UriBuilder replaceQuery(String name, Iterable<?> values) {
            Iterable<QueryValue> queryValues = Iterables.transform(Preconditions.checkNotNull(values, "values of %s", (Object)name), QUERY_VALUE_TRANSFORMER);
            this.query.replaceValues(Preconditions.checkNotNull(name, "name"), queryValues);
            return this;
        }

        public UriBuilder replaceQuery(String name, String ... values) {
            return this.replaceQuery(name, Arrays.asList(Preconditions.checkNotNull(values, "values of %s", (Object)name)));
        }

        public UriBuilder replaceQuery(Map<String, ?> parameters) {
            return this.replaceQuery(Multimaps.forMap(parameters));
        }

        public UriBuilder replaceQuery(Multimap<String, ?> parameters) {
            for (String key : Preconditions.checkNotNull(parameters, "parameters").keySet()) {
                this.replaceQuery(key, parameters.get(key));
            }
            return this;
        }

        private UriBuilder(CharSequence uri) {
            this(URI.create(UriBuilder.escapeSpecialChars(Preconditions.checkNotNull(uri, "uri"))));
        }

        private static String escapeSpecialChars(CharSequence uri) {
            if (uri.length() < 3) {
                return uri.toString();
            }
            StringBuilder builder = new StringBuilder();
            block4: for (char c : Lists.charactersOf(uri)) {
                switch (c) {
                    case '{': {
                        builder.append("((");
                        continue block4;
                    }
                    case '}': {
                        builder.append("))");
                        continue block4;
                    }
                }
                builder.append(c);
            }
            return builder.toString();
        }

        private static String unescapeSpecialChars(CharSequence uri) {
            if (uri.length() < 5) {
                return uri.toString();
            }
            char last = uri.charAt(0);
            StringBuilder builder = new StringBuilder();
            for (char c : Lists.charactersOf(uri)) {
                switch (c) {
                    case '(': {
                        if (last == '(') {
                            builder.setCharAt(builder.length() - 1, '{');
                            break;
                        }
                        builder.append('(');
                        break;
                    }
                    case ')': {
                        if (last == ')') {
                            builder.setCharAt(builder.length() - 1, '}');
                            break;
                        }
                        builder.append(')');
                        break;
                    }
                    default: {
                        builder.append(c);
                    }
                }
                last = c;
            }
            return builder.toString();
        }

        private UriBuilder(URI uri) {
            Preconditions.checkNotNull(uri, "uri");
            this.scheme = uri.getScheme();
            this.host = uri.getHost();
            Integer n = this.port = uri.getPort() == -1 ? null : Integer.valueOf(uri.getPort());
            if (uri.getRawPath() != null) {
                this.path(UriBuilder.unescapeSpecialChars(uri.getRawPath()));
            }
            if (uri.getRawQuery() != null) {
                this.query(Queries.queryParser().apply(UriBuilder.unescapeSpecialChars(uri.getRawQuery())));
            }
        }

        public URI build() {
            return this.build(ImmutableMap.of());
        }

        public URI build(Map<String, ?> variables, boolean encodePath) {
            try {
                return new URI(this.expand(variables, encodePath));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public URI build(Map<String, ?> variables) {
            try {
                return new URI(this.expand(variables, true));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private String expand(Map<String, ?> variables, boolean encodePath) {
            StringBuilder b = new StringBuilder();
            if (this.scheme != null) {
                b.append(this.scheme).append("://");
            }
            if (this.host != null) {
                b.append(UriTemplates.expand(this.host, variables));
            }
            if (this.port != null) {
                b.append(':').append(this.port);
            }
            if (this.path != null) {
                if (encodePath) {
                    b.append(Strings2.urlEncode(UriTemplates.expand(this.path, variables), this.skipPathEncoding));
                } else {
                    b.append(UriTemplates.expand(this.path, variables));
                }
            }
            if (!this.query.isEmpty()) {
                b.append('?').append(Queries.buildQueryLine(this.query));
            }
            return b.toString();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            if (this.scheme != null) {
                b.append(this.scheme).append("://");
            }
            if (this.host != null) {
                b.append(this.host);
            }
            if (this.port != null) {
                b.append(':').append(this.port);
            }
            if (this.path != null) {
                b.append(this.path);
            }
            if (!this.query.isEmpty()) {
                b.append('?').append(Queries.buildQueryLine(this.query));
            }
            return b.toString();
        }
    }
}

