/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain.chef;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class DataBag
extends ForwardingMap<String, String> {
    private String name;
    private Map<String, String> items;

    public static Builder builder() {
        return new Builder();
    }

    public DataBag(String name, Map<String, String> items) {
        this.name = Preconditions.checkNotNull(name, "name must be set");
        this.items = ImmutableMap.copyOf(Preconditions.checkNotNull(items, "items must be set"));
    }

    @Override
    protected Map<String, String> delegate() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getItems() {
        return this.items;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataBag other = (DataBag)obj;
        return Objects.equal(this.name, other.name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }

    public static class Builder {
        private String name;
        private ImmutableMap.Builder<String, String> items = ImmutableMap.builder();

        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name must be set");
            return this;
        }

        public Builder item(String name, String jsonData) {
            this.items.put(Preconditions.checkNotNull(name, "name must be set"), Preconditions.checkNotNull(jsonData, "jsonData must be set"));
            return this;
        }

        public Builder items(Map<String, String> items) {
            this.items.putAll(Preconditions.checkNotNull(items, "items must be set"));
            return this;
        }

        public DataBag build() {
            return new DataBag(this.name, this.items.build());
        }
    }
}

