/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.MultiDataStoreAware;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDataStore
implements DataStore {
    private static Logger log = LoggerFactory.getLogger(MultiDataStore.class);
    private DataStore primaryDataStore;
    private DataStore archiveDataStore;
    private int maxAge = 60;
    private ReentrantLock moveDataTaskLock = new ReentrantLock();
    private boolean moveDataTaskRunning = false;
    private Thread moveDataTaskThread;
    private int moveDataTaskSleep = 604800;
    private Calendar moveDataTaskNextRun = Calendar.getInstance();
    private boolean delayedDelete = false;
    private long delayedDeleteSleep = 86400L;
    private FileSystemResource identifiersToDeleteFile = null;
    private Thread deleteDelayedIdentifiersTaskThread;
    private final String IDENTIFIERS_TO_DELETE_FILE_KEY = "identifiersToDelete";
    private long sleepBetweenRecords = 100L;

    public MultiDataStore() {
        if (this.moveDataTaskNextRun.get(11) >= 1) {
            this.moveDataTaskNextRun.add(5, 1);
        }
        this.moveDataTaskNextRun.set(11, 1);
        this.moveDataTaskNextRun.set(12, 0);
        this.moveDataTaskNextRun.set(13, 0);
        this.moveDataTaskNextRun.set(14, 0);
    }

    public void setPrimaryDataStore(DataStore dataStore) {
        this.primaryDataStore = dataStore;
    }

    public void setArchiveDataStore(DataStore dataStore) {
        this.archiveDataStore = dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        if (this.moveDataTaskRunning) {
            this.moveDataTaskLock.lock();
        }
        try {
            DataRecord dataRecord = this.primaryDataStore.getRecordIfStored(identifier);
            if (dataRecord == null) {
                dataRecord = this.archiveDataStore.getRecordIfStored(identifier);
            }
            DataRecord dataRecord2 = dataRecord;
            return dataRecord2;
        }
        finally {
            if (this.moveDataTaskRunning) {
                this.moveDataTaskLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        if (this.moveDataTaskRunning) {
            this.moveDataTaskLock.lock();
        }
        try {
            DataRecord dataRecord = this.primaryDataStore.getRecord(identifier);
            return dataRecord;
        }
        catch (DataStoreException e) {
            DataRecord dataRecord = this.archiveDataStore.getRecord(identifier);
            return dataRecord;
        }
        finally {
            if (this.moveDataTaskRunning) {
                this.moveDataTaskLock.unlock();
            }
        }
    }

    @Override
    public DataRecord addRecord(InputStream stream) throws DataStoreException {
        return this.primaryDataStore.addRecord(stream);
    }

    @Override
    public void updateModifiedDateOnAccess(long before) {
        this.archiveDataStore.updateModifiedDateOnAccess(before);
    }

    @Override
    public int deleteAllOlderThan(long min) throws DataStoreException {
        return this.archiveDataStore.deleteAllOlderThan(min);
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return this.archiveDataStore.getAllIdentifiers();
    }

    @Override
    public DataRecord getRecordFromReference(String reference) throws DataStoreException {
        DataRecord record = this.primaryDataStore.getRecordFromReference(reference);
        if (record == null) {
            record = this.archiveDataStore.getRecordFromReference(reference);
        }
        return record;
    }

    @Override
    public void init(String homeDir) throws RepositoryException {
        if (this.delayedDelete) {
            LocalFileSystem fileSystem = new LocalFileSystem();
            fileSystem.setRoot(new File(homeDir));
            this.identifiersToDeleteFile = new FileSystemResource(fileSystem, "/identifiersToDelete");
        }
        this.moveDataTaskThread = new Thread((Runnable)new MoveDataTask(), "Jackrabbit-MulitDataStore-MoveDataTaskThread");
        this.moveDataTaskThread.setDaemon(true);
        this.moveDataTaskThread.start();
        log.info("MultiDataStore-MoveDataTask thread started; first run scheduled at " + this.moveDataTaskNextRun.getTime());
        if (this.delayedDelete) {
            try {
                if (this.identifiersToDeleteFile != null && this.identifiersToDeleteFile.exists() && this.identifiersToDeleteFile.lastModified() + this.delayedDeleteSleep * 1000L < System.currentTimeMillis()) {
                    this.deleteDelayedIdentifiersTaskThread = new Thread((Runnable)new DeleteDelayedIdentifiersTask(0L), "Jackrabbit-MultiDataStore-DeleteDelayedIdentifiersTaskThread");
                    this.deleteDelayedIdentifiersTaskThread.setDaemon(true);
                    this.deleteDelayedIdentifiersTaskThread.start();
                    log.info("Old entries in the identifiersToDelete File found. DeleteDelayedIdentifiersTask-Thread started now.");
                }
            }
            catch (FileSystemException e) {
                throw new RepositoryException("I/O error while reading from '" + this.identifiersToDeleteFile.getPath() + "'", e);
            }
        }
    }

    @Override
    public int getMinRecordLength() {
        return this.primaryDataStore.getMinRecordLength();
    }

    @Override
    public void close() throws DataStoreException {
        DataStoreException lastException;
        block13: {
            block12: {
                block11: {
                    lastException = null;
                    try {
                        this.primaryDataStore.close();
                    }
                    catch (DataStoreException e) {
                        lastException = e;
                    }
                    try {
                        this.archiveDataStore.close();
                    }
                    catch (DataStoreException e) {
                        if (lastException == null) break block11;
                        lastException = new DataStoreException(lastException);
                    }
                }
                try {
                    if (this.moveDataTaskRunning) {
                        this.moveDataTaskThread.interrupt();
                    }
                }
                catch (Exception e) {
                    if (lastException == null) break block12;
                    lastException = new DataStoreException(lastException);
                }
            }
            try {
                if (this.deleteDelayedIdentifiersTaskThread != null && this.deleteDelayedIdentifiersTaskThread.isAlive()) {
                    this.deleteDelayedIdentifiersTaskThread.interrupt();
                }
            }
            catch (Exception e) {
                if (lastException == null) break block13;
                lastException = new DataStoreException(lastException);
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    @Override
    public void clearInUse() {
        this.archiveDataStore.clearInUse();
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMoveDataTaskSleep() {
        return this.moveDataTaskSleep;
    }

    public int getMoveDataTaskFirstRunHourOfDay() {
        return this.moveDataTaskNextRun.get(11);
    }

    public void setMoveDataTaskSleep(int sleep) {
        this.moveDataTaskSleep = sleep;
    }

    public void setMoveDataTaskFirstRunHourOfDay(int hourOfDay) {
        this.moveDataTaskNextRun = Calendar.getInstance();
        if (this.moveDataTaskNextRun.get(11) >= hourOfDay) {
            this.moveDataTaskNextRun.add(5, 1);
        }
        this.moveDataTaskNextRun.set(11, hourOfDay);
        this.moveDataTaskNextRun.set(12, 0);
        this.moveDataTaskNextRun.set(13, 0);
        this.moveDataTaskNextRun.set(14, 0);
    }

    public void setSleepBetweenRecords(long millis) {
        this.sleepBetweenRecords = millis;
    }

    public long getSleepBetweenRecords() {
        return this.sleepBetweenRecords;
    }

    public boolean isDelayedDelete() {
        return this.delayedDelete;
    }

    public void setDelayedDelete(boolean delayedDelete) {
        this.delayedDelete = delayedDelete;
    }

    public long getDelayedDeleteSleep() {
        return this.delayedDeleteSleep;
    }

    public void setDelayedDeleteSleep(long delayedDeleteSleep) {
        this.delayedDeleteSleep = delayedDeleteSleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeDelayedDataIdentifier(DataIdentifier identifier) {
        boolean bl;
        BufferedWriter writer = null;
        try {
            File identifierFile = new File(((LocalFileSystem)this.identifiersToDeleteFile.getFileSystem()).getPath(), this.identifiersToDeleteFile.getPath());
            writer = new BufferedWriter(new FileWriter(identifierFile, true));
            writer.write(identifier.toString());
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                log.warn("I/O error while saving DataIdentifier (stacktrace on DEBUG log level) to '" + this.identifiersToDeleteFile.getPath() + "': " + e.getMessage());
                log.debug("Root cause: ", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)writer);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean purgeDelayedDeleteFile() {
        boolean bl;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(this.identifiersToDeleteFile.getOutputStream()));
            writer.write("");
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                log.warn("I/O error while purging (stacktrace on DEBUG log level) the identifiersToDelete file '" + this.identifiersToDeleteFile.getPath() + "': " + e.getMessage());
                log.debug("Root cause: ", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)writer);
        return bl;
    }

    public class DeleteDelayedIdentifiersTask
    implements Runnable {
        boolean run = true;
        private long sleepTime = 0L;

        public DeleteDelayedIdentifiersTask(long sleep) {
            this.sleepTime = sleep * 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            if (MultiDataStore.this.moveDataTaskRunning) {
                log.warn("It's not supported to run the DeleteDelayedIdentifiersTask while the MoveDataTask is running.");
                return;
            }
            while (this.run && !Thread.currentThread().isInterrupted()) {
                if (this.sleepTime > 0L) {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                log.info("Start to delete DataRecords from the primary data store.");
                BufferedReader reader = null;
                ArrayList<DataIdentifier> problemIdentifiers = new ArrayList<DataIdentifier>();
                try {
                    block25: {
                        String s;
                        int deleted = 0;
                        reader = new BufferedReader(new InputStreamReader(MultiDataStore.this.identifiersToDeleteFile.getInputStream()));
                        while ((s = reader.readLine()) != null && !s.equals("")) {
                            DataIdentifier identifier = new DataIdentifier(s);
                            try {
                                MultiDataStore.this.moveDataTaskLock.lock();
                                ((MultiDataStoreAware)((Object)MultiDataStore.this.primaryDataStore)).deleteRecord(identifier);
                                ++deleted;
                            }
                            catch (DataStoreException e) {
                                log.error("Failed to delete DataRecord. DataIdentifier: " + identifier, (Throwable)e);
                                problemIdentifiers.add(identifier);
                            }
                            finally {
                                MultiDataStore.this.moveDataTaskLock.unlock();
                            }
                            Thread.sleep(MultiDataStore.this.sleepBetweenRecords);
                        }
                        log.info("Deleted " + deleted + " DataRecords from the primary data store.");
                        if (problemIdentifiers.isEmpty()) {
                            try {
                                MultiDataStore.this.identifiersToDeleteFile.delete();
                            }
                            catch (FileSystemException e) {
                                log.warn("Unable to delete the identifiersToDelete File.");
                                if (MultiDataStore.this.purgeDelayedDeleteFile()) break block25;
                                log.error("Unable to purge the identifiersToDelete File.");
                            }
                        } else if (MultiDataStore.this.purgeDelayedDeleteFile()) {
                            for (int x = 0; x < problemIdentifiers.size(); ++x) {
                                MultiDataStore.this.writeDelayedDataIdentifier((DataIdentifier)problemIdentifiers.get(x));
                            }
                        }
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    this.run = false;
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted: stopping delayed-delete task.");
                    Thread.currentThread().interrupt();
                }
                catch (Exception e2) {
                    log.warn("Failed to run delayed-delete task.", (Throwable)e2);
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeQuietly(reader);
                    this.run = false;
                }
            }
        }
    }

    public class MoveDataTask
    implements Runnable {
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    log.info("Next move-data task run scheduled at " + MultiDataStore.this.moveDataTaskNextRun.getTime());
                    long sleepTime = MultiDataStore.this.moveDataTaskNextRun.getTimeInMillis() - System.currentTimeMillis();
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    MultiDataStore.this.moveDataTaskRunning = true;
                    this.moveOutdatedData();
                    MultiDataStore.this.moveDataTaskRunning = false;
                    MultiDataStore.this.moveDataTaskNextRun.add(13, MultiDataStore.this.moveDataTaskSleep);
                    if (!MultiDataStore.this.delayedDelete) continue;
                    if (MultiDataStore.this.deleteDelayedIdentifiersTaskThread != null && MultiDataStore.this.deleteDelayedIdentifiersTaskThread.isAlive()) {
                        log.warn("The DeleteDelayedIdentifiersTask-Thread is already running.");
                        continue;
                    }
                    MultiDataStore.this.deleteDelayedIdentifiersTaskThread = new Thread((Runnable)new DeleteDelayedIdentifiersTask(MultiDataStore.this.delayedDeleteSleep), "Jackrabbit-MultiDataStore-DeleteDelayedIdentifiersTaskThread");
                    MultiDataStore.this.deleteDelayedIdentifiersTaskThread.setDaemon(true);
                    MultiDataStore.this.deleteDelayedIdentifiersTaskThread.start();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            log.warn("Interrupted: stopping move-data task.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void moveOutdatedData() {
            try {
                long now = System.currentTimeMillis();
                long maxAgeMilli = 86400000L * (long)MultiDataStore.this.maxAge;
                log.debug("Collecting all Identifiers from PrimaryDataStore...");
                Iterator<DataIdentifier> allIdentifiers = MultiDataStore.this.primaryDataStore.getAllIdentifiers();
                int moved = 0;
                while (allIdentifiers.hasNext()) {
                    DataIdentifier identifier = allIdentifiers.next();
                    DataRecord dataRecord = MultiDataStore.this.primaryDataStore.getRecord(identifier);
                    if (dataRecord.getLastModified() + maxAgeMilli < now) {
                        try {
                            MultiDataStore.this.moveDataTaskLock.lock();
                            if (MultiDataStore.this.delayedDelete) {
                                if (MultiDataStore.this.writeDelayedDataIdentifier(identifier)) {
                                    MultiDataStore.this.archiveDataStore.addRecord(dataRecord.getStream());
                                    ++moved;
                                }
                            } else {
                                MultiDataStore.this.archiveDataStore.addRecord(dataRecord.getStream());
                                ((MultiDataStoreAware)((Object)MultiDataStore.this.primaryDataStore)).deleteRecord(identifier);
                                ++moved;
                            }
                            if (moved % 100 == 0) {
                                log.debug("Moving DataRecord's... ({})", (Object)moved);
                            }
                        }
                        catch (DataStoreException e) {
                            log.error("Failed to move DataRecord. DataIdentifier: " + identifier, (Throwable)e);
                        }
                        finally {
                            MultiDataStore.this.moveDataTaskLock.unlock();
                        }
                    }
                    Thread.sleep(MultiDataStore.this.sleepBetweenRecords);
                }
                if (MultiDataStore.this.delayedDelete) {
                    log.info("Moved " + moved + " DataRecords to the archive data store. The DataRecords in the primary data store will be removed in " + MultiDataStore.this.delayedDeleteSleep + " seconds.");
                } else {
                    log.info("Moved " + moved + " DataRecords to the archive data store.");
                }
            }
            catch (Exception e) {
                log.warn("Failed to run move-data task.", (Throwable)e);
            }
        }
    }
}

