/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.data.AsyncUploadCache;
import org.apache.jackrabbit.core.data.LocalCache;
import org.apache.jackrabbit.core.data.util.NamedThreadFactory;
import org.apache.jackrabbit.core.fs.local.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLocalCache
extends TestCase {
    private static final String CACHE_DIR = "target/cache";
    private static final String TEMP_DIR = "target/temp";
    private static final String TARGET_DIR = "target";
    private static final Logger LOG = LoggerFactory.getLogger(TestLocalCache.class);

    protected void setUp() {
        try {
            File cachedir = new File(CACHE_DIR);
            if (cachedir.exists()) {
                FileUtil.delete(cachedir);
            }
            cachedir.mkdirs();
            File tempdir = new File(TEMP_DIR);
            if (tempdir.exists()) {
                FileUtil.delete(tempdir);
            }
            tempdir.mkdirs();
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestLocalCache.fail();
        }
    }

    protected void tearDown() throws IOException {
        File tempdir;
        File cachedir = new File(CACHE_DIR);
        if (cachedir.exists()) {
            FileUtils.deleteQuietly((File)cachedir);
        }
        if ((tempdir = new File(TEMP_DIR)).exists()) {
            FileUtils.deleteQuietly((File)tempdir);
        }
    }

    public void testStoreRetrieve() {
    }

    public void testAutoPurge() {
    }

    public void testAutoPurgeWithPendingUpload() {
    }

    public void testConcurrentInitWithStore() {
        try {
            AsyncUploadCache pendingFiles = new AsyncUploadCache();
            pendingFiles.init(TARGET_DIR, CACHE_DIR, 100);
            pendingFiles.reset();
            LocalCache cache = new LocalCache(CACHE_DIR, TEMP_DIR, 10000000L, 0.95, 0.7, pendingFiles);
            Random random = new Random(12345L);
            int fileUploads = 1000;
            HashMap<String, byte[]> byteMap = new HashMap<String, byte[]>(fileUploads);
            for (int i = 0; i < fileUploads; ++i) {
                byte[] data = new byte[100];
                random.nextBytes(data);
                String key = "a" + i;
                byteMap.put(key, data);
                cache.store(key, new ByteArrayInputStream((byte[])byteMap.get(key)));
            }
            ExecutorService executor = Executors.newFixedThreadPool(10, new NamedThreadFactory("localcache-store-worker"));
            cache = new LocalCache(CACHE_DIR, TEMP_DIR, 10000000L, 0.95, 0.7, pendingFiles);
            executor.execute(new StoreWorker(cache, byteMap));
            executor.shutdown();
            while (!executor.awaitTermination(15L, TimeUnit.SECONDS)) {
            }
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestLocalCache.fail();
        }
    }

    protected void assertEquals(InputStream a, InputStream b) throws IOException {
        int ai;
        do {
            ai = a.read();
            int bi = b.read();
            TestLocalCache.assertEquals((int)ai, (int)bi);
        } while (ai >= 0);
    }

    private class StoreWorker
    implements Runnable {
        Map<String, byte[]> byteMap;
        LocalCache cache;
        Random random;

        private StoreWorker(LocalCache cache, Map<String, byte[]> byteMap) {
            this.byteMap = byteMap;
            this.cache = cache;
            this.random = new Random(byteMap.size());
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 100; ++i) {
                    String key = "a" + this.random.nextInt(this.byteMap.size());
                    LOG.debug("key=" + key);
                    this.cache.store(key, new ByteArrayInputStream(this.byteMap.get(key)));
                }
            }
            catch (Exception e) {
                LOG.error("error:", (Throwable)e);
                Assert.fail();
            }
        }
    }
}

