/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.ForeignSegmentDocId;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.jackrabbit.core.query.lucene.SingleTermDocs;
import org.apache.jackrabbit.core.query.lucene.TermFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public final class CachingMultiIndexReader
extends MultiReader
implements HierarchyResolver,
MultiIndexReader {
    private ReadOnlyIndexReader[] subReaders;
    private final Map<Long, OffsetReader> readersByCreationTick = new HashMap<Long, OffsetReader>();
    private final DocNumberCache cache;
    private int refCount = 1;

    public CachingMultiIndexReader(ReadOnlyIndexReader[] subReaders, DocNumberCache cache) {
        super((IndexReader[])subReaders);
        this.cache = cache;
        this.subReaders = subReaders;
        for (int i = 0; i < subReaders.length; ++i) {
            OffsetReader offsetReader = new OffsetReader(subReaders[i], this.starts[i]);
            this.readersByCreationTick.put(subReaders[i].getCreationTick(), offsetReader);
        }
    }

    @Override
    public int[] getParents(int n, int[] docNumbers) throws IOException {
        DocId id = this.getParentDocId(n);
        return id.getDocumentNumbers(this, docNumbers);
    }

    public DocId getParentDocId(int n) throws IOException {
        int i = this.readerIndex(n);
        DocId id = this.subReaders[i].getParent(n - this.starts[i]);
        return id.applyOffset(this.starts[i]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermDocs termDocs(Term term) throws IOException {
        if (term != null && term.field() == FieldNames.UUID) {
            OffsetReader offsetReader;
            DocNumberCache.Entry e = this.cache.get(term.text());
            if (e != null && (offsetReader = this.readersByCreationTick.get(e.creationTick)) != null && !offsetReader.reader.isDeleted(e.doc)) {
                return new SingleTermDocs(e.doc + offsetReader.offset);
            }
            for (int i = 0; i < this.subReaders.length; ++i) {
                TermDocs docs = this.subReaders[i].termDocs(term);
                try {
                    if (!docs.next()) continue;
                    SingleTermDocs singleTermDocs = new SingleTermDocs(docs.doc() + this.starts[i]);
                    return singleTermDocs;
                }
                finally {
                    docs.close();
                }
            }
        }
        return super.termDocs(term);
    }

    synchronized void acquire() {
        ++this.refCount;
    }

    @Override
    public final synchronized void release() throws IOException {
        if (--this.refCount == 0) {
            this.close();
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        for (ReadOnlyIndexReader subReader : this.subReaders) {
            subReader.release();
        }
        this.subReaders = null;
        this.readersByCreationTick.clear();
    }

    @Override
    public IndexReader[] getIndexReaders() {
        IndexReader[] readers = new IndexReader[this.subReaders.length];
        System.arraycopy(this.subReaders, 0, readers, 0, this.subReaders.length);
        return readers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForeignSegmentDocId createDocId(NodeId id) throws IOException {
        Term term = TermFactory.createUUIDTerm(id.toString());
        for (ReadOnlyIndexReader subReader : this.subReaders) {
            TermDocs docs = subReader.termDocs(term);
            try {
                if (!docs.next()) continue;
                int doc = docs.doc();
                long tick = subReader.getCreationTick();
                ForeignSegmentDocId foreignSegmentDocId = new ForeignSegmentDocId(doc, tick);
                return foreignSegmentDocId;
            }
            finally {
                docs.close();
            }
        }
        return null;
    }

    @Override
    public int getDocumentNumber(ForeignSegmentDocId docId) {
        OffsetReader r = this.readersByCreationTick.get(docId.getCreationTick());
        if (r != null && !r.reader.isDeleted(docId.getDocNumber())) {
            return r.offset + docId.getDocNumber();
        }
        return -1;
    }

    private static final class OffsetReader {
        private final ReadOnlyIndexReader reader;
        private final int offset;

        OffsetReader(ReadOnlyIndexReader reader, int offset) {
            this.reader = reader;
            this.offset = offset;
        }
    }
}

