/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.query.lucene.AbstractNamespaceMappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedNamespaceMappings
extends AbstractNamespaceMappings {
    private static Logger log = LoggerFactory.getLogger(FileBasedNamespaceMappings.class);
    private final File storage;
    private Map<String, String> prefixToURI = new HashMap<String, String>();
    private Map<String, String> uriToPrefix = new HashMap<String, String>();
    private int prefixCount;

    public FileBasedNamespaceMappings(File file) throws IOException {
        this.storage = file;
        this.load();
    }

    @Override
    public synchronized String getURI(String prefix) throws NamespaceException {
        if (!this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
        return this.prefixToURI.get(prefix);
    }

    @Override
    public synchronized String getPrefix(String uri) throws NamespaceException {
        String prefix = this.uriToPrefix.get(uri);
        if (prefix == null) {
            while (this.prefixToURI.get(String.valueOf(this.prefixCount)) != null) {
                ++this.prefixCount;
            }
            prefix = String.valueOf(this.prefixCount);
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
            log.debug("adding new namespace mapping: " + prefix + " -> " + uri);
            try {
                this.store();
            }
            catch (IOException e) {
                throw new NamespaceException("Could not obtain a prefix for uri: " + uri, e);
            }
        }
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        if (this.storage.exists()) {
            FileInputStream in = new FileInputStream(this.storage);
            try {
                Properties props = new Properties();
                log.debug("loading namespace mappings...");
                props.load(in);
                for (Object o : props.keySet()) {
                    String prefix = (String)o;
                    String uri = props.getProperty(prefix);
                    log.debug(prefix + " -> " + uri);
                    this.prefixToURI.put(prefix, uri);
                    this.uriToPrefix.put(uri, prefix);
                }
                this.prefixCount = props.size();
                log.debug("namespace mappings loaded.");
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        Properties props = new Properties();
        props.putAll(this.prefixToURI);
        OutputStream out = new FileOutputStream(this.storage);
        try {
            out = new BufferedOutputStream(out);
            props.store(out, null);
        }
        finally {
            out.close();
        }
    }
}

