/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.apache.jackrabbit.core.query.lucene.WildcardQuery;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class JackrabbitQueryParser
extends QueryParser {
    private final SynonymProvider synonymProvider;
    private final PerQueryCache cache;

    public JackrabbitQueryParser(String fieldName, Analyzer analyzer, SynonymProvider synonymProvider, PerQueryCache cache) {
        super(Version.LUCENE_24, fieldName, analyzer);
        this.synonymProvider = synonymProvider;
        this.cache = cache;
        this.setAllowLeadingWildcard(true);
        this.setDefaultOperator(QueryParser.Operator.AND);
    }

    public Query parse(String textsearch) throws ParseException {
        StringBuffer rewritten = new StringBuffer();
        textsearch = textsearch.replaceAll("AND", "and");
        textsearch = textsearch.replaceAll("NOT", "not");
        boolean escaped = false;
        for (int i = 0; i < textsearch.length(); ++i) {
            if (textsearch.charAt(i) == '\\') {
                if (escaped) {
                    rewritten.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (textsearch.charAt(i) == '\'') {
                if (escaped) {
                    escaped = false;
                }
                rewritten.append(textsearch.charAt(i));
                continue;
            }
            if (textsearch.charAt(i) == '~') {
                if (i == 0 || Character.isWhitespace(textsearch.charAt(i - 1))) {
                    rewritten.append("\\");
                }
                rewritten.append('~');
                continue;
            }
            if (textsearch.charAt(i) == ':') {
                rewritten.append("\\:");
                continue;
            }
            if (escaped) {
                rewritten.append('\\');
                escaped = false;
            }
            rewritten.append(textsearch.charAt(i));
        }
        return super.parse(rewritten.toString());
    }

    protected Query getSynonymQuery(String field, String termStr) throws ParseException {
        ArrayList<BooleanClause> synonyms = new ArrayList<BooleanClause>();
        synonyms.add(new BooleanClause(this.getFieldQuery(field, termStr), BooleanClause.Occur.SHOULD));
        if (this.synonymProvider != null) {
            for (String term : this.synonymProvider.getSynonyms(termStr)) {
                synonyms.add(new BooleanClause(this.getFieldQuery(field, term), BooleanClause.Occur.SHOULD));
            }
        }
        if (synonyms.size() == 1) {
            return ((BooleanClause)synonyms.get(0)).getQuery();
        }
        return this.getBooleanQuery(synonyms);
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        return this.getFieldQuery(field, queryText, true);
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        if (queryText.startsWith("~")) {
            return this.getSynonymQuery(field, queryText.substring(1));
        }
        return super.getFieldQuery(field, queryText, quoted);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        Analyzer a = this.getAnalyzer();
        TokenStream ts = a.tokenStream(field, new StringReader(termStr));
        int count = 0;
        boolean isCJ = false;
        try {
            TypeAttribute t = ts.addAttribute(TypeAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                ++count;
                isCJ = StandardTokenizer.TOKEN_TYPES[7].equals(t.type());
            }
            ts.end();
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage());
        }
        finally {
            try {
                ts.close();
            }
            catch (IOException e) {}
        }
        if (count > 1 && isCJ) {
            return this.getFieldQuery(field, termStr);
        }
        return this.getWildcardQuery(field, termStr + "*");
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (this.getLowercaseExpandedTerms()) {
            termStr = termStr.toLowerCase();
        }
        return new WildcardQuery(field, null, this.translateWildcards(termStr), this.cache);
    }

    private String translateWildcards(String input) {
        StringBuffer translated = new StringBuffer(input.length());
        boolean escaped = false;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\\') {
                if (escaped) {
                    translated.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (input.charAt(i) == '*') {
                if (escaped) {
                    translated.append('*');
                    escaped = false;
                    continue;
                }
                translated.append('%');
                continue;
            }
            if (input.charAt(i) == '?') {
                if (escaped) {
                    translated.append('?');
                    escaped = false;
                    continue;
                }
                translated.append('_');
                continue;
            }
            if (input.charAt(i) == '%' || input.charAt(i) == '_') {
                escaped = false;
                translated.append('\\').append(input.charAt(i));
                continue;
            }
            if (escaped) {
                translated.append('\\');
                escaped = false;
            }
            translated.append(input.charAt(i));
        }
        return translated.toString();
    }
}

