/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.FieldComparatorBase;
import org.apache.jackrabbit.core.query.lucene.FieldComparatorDecorator;
import org.apache.lucene.analysis.ASCIIFoldingFilter;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;

public class NormalizeSortComparator
extends FieldComparatorSource {
    private final FieldComparatorSource base;

    public NormalizeSortComparator(FieldComparatorSource base) {
        this.base = base;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        FieldComparator<?> comparator = this.base.newComparator(fieldname, numHits, sortPos, reversed);
        assert (comparator instanceof FieldComparatorBase);
        return new FieldComparatorDecorator((FieldComparatorBase)comparator){

            @Override
            protected Comparable<?> sortValue(int doc) {
                Object comparable = super.sortValue(doc);
                if (comparable != null) {
                    char[] output;
                    char[] input = comparable.toString().toCharArray();
                    int length = ASCIIFoldingFilter.foldToASCII((char[])input, (int)0, (char[])(output = new char[input.length * 4]), (int)0, (int)input.length);
                    boolean different = length != input.length;
                    for (int i = 0; i < length; ++i) {
                        char c = output[i];
                        if ('A' <= c && c <= 'Z') {
                            output[i] = (char)(c + 97 - 65);
                        }
                        if (different || input[i] == output[i]) continue;
                        different = true;
                    }
                    if (different) {
                        comparable = new String(output, 0, length);
                    }
                }
                return comparable;
            }
        };
    }
}

