/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.JackrabbitQuery;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.TermFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.Weight;

public class QueryHitsQuery
extends Query
implements JackrabbitQuery {
    private final QueryHits hits;

    public QueryHitsQuery(QueryHits hits) {
        this.hits = hits;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new QueryHitsQueryWeight(searcher.getSimilarity());
    }

    @Override
    public String toString(String field) {
        return "QueryHitsQuery";
    }

    @Override
    public void extractTerms(Set<Term> terms) {
    }

    @Override
    public QueryHits execute(JackrabbitIndexSearcher searcher, SessionImpl session, Sort sort) throws IOException {
        if (sort.getSort().length == 0) {
            return this.hits;
        }
        return null;
    }

    public class QueryHitsQueryScorer
    extends Scorer {
        private final Iterator<Integer> docs;
        private final Map<Integer, Float> scores;
        private Integer currentDoc;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected QueryHitsQueryScorer(IndexReader reader, Similarity similarity) throws IOException {
            super(similarity);
            this.scores = new HashMap<Integer, Float>();
            this.currentDoc = null;
            TreeSet<Integer> sortedDocs = new TreeSet<Integer>();
            try {
                ScoreNode node;
                while ((node = QueryHitsQuery.this.hits.nextScoreNode()) != null) {
                    String uuid = node.getNodeId().toString();
                    Term id = TermFactory.createUUIDTerm(uuid);
                    TermDocs tDocs = reader.termDocs(id);
                    try {
                        if (!tDocs.next()) continue;
                        Integer doc = tDocs.doc();
                        sortedDocs.add(doc);
                        this.scores.put(doc, Float.valueOf(node.getScore()));
                    }
                    finally {
                        tDocs.close();
                    }
                }
            }
            finally {
                QueryHitsQuery.this.hits.close();
            }
            this.docs = sortedDocs.iterator();
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.currentDoc == Integer.MAX_VALUE) {
                return this.currentDoc;
            }
            this.currentDoc = this.docs.hasNext() ? this.docs.next() : Integer.MAX_VALUE;
            return this.currentDoc;
        }

        @Override
        public int docID() {
            return this.currentDoc == null ? -1 : this.currentDoc;
        }

        @Override
        public float score() throws IOException {
            return this.scores.get(this.currentDoc).floatValue();
        }

        @Override
        public int advance(int target) throws IOException {
            if (this.currentDoc == Integer.MAX_VALUE) {
                return this.currentDoc;
            }
            if (target == Integer.MAX_VALUE) {
                this.currentDoc = Integer.MAX_VALUE;
                return this.currentDoc;
            }
            do {
                if (this.nextDoc() != Integer.MAX_VALUE) continue;
                return Integer.MAX_VALUE;
            } while (target > this.docID());
            return this.docID();
        }
    }

    public class QueryHitsQueryWeight
    extends Weight {
        private final Similarity similarity;

        public QueryHitsQueryWeight(Similarity similarity) {
            this.similarity = similarity;
        }

        @Override
        public Query getQuery() {
            return QueryHitsQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new QueryHitsQueryScorer(reader, this.similarity);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

