/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AbstractAccessControlManager;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccessManager
extends AbstractAccessControlManager
implements AccessManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAccessManager.class);
    private boolean initialized;
    private NamePathResolver resolver;
    private Set<Principal> principals;
    private AccessControlProvider acProvider;
    private AccessControlEditor editor;
    private WorkspaceAccess wspAccess;
    private HierarchyManager hierMgr;
    private PrivilegeManager privilegeManager;
    private CompiledPermissions compiledPermissions;

    @Override
    public void init(AMContext amContext) throws AccessDeniedException, Exception {
        this.init(amContext, null, null);
    }

    @Override
    public void init(AMContext amContext, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessManager) throws AccessDeniedException, Exception {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized.");
        }
        this.acProvider = acProvider;
        this.resolver = amContext.getNamePathResolver();
        this.hierMgr = amContext.getHierarchyManager();
        Subject subject = amContext.getSubject();
        this.principals = subject == null ? Collections.emptySet() : subject.getPrincipals();
        this.wspAccess = new WorkspaceAccess(wspAccessManager, DefaultAccessManager.isSystemOrAdmin(amContext.getSession()));
        this.privilegeManager = amContext.getPrivilegeManager();
        if (acProvider != null) {
            this.editor = acProvider.getEditor(amContext.getSession());
            this.compiledPermissions = acProvider.compilePermissions(this.principals);
        } else {
            log.warn("No AccessControlProvider defined -> no access is granted.");
            this.editor = null;
            this.compiledPermissions = CompiledPermissions.NO_PERMISSION;
        }
        this.initialized = true;
        if (!this.canAccess(amContext.getWorkspaceName())) {
            throw new AccessDeniedException("Not allowed to access Workspace " + amContext.getWorkspaceName());
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("Manager is not initialized.");
        }
        this.initialized = false;
        this.compiledPermissions.close();
        this.hierMgr = null;
        this.acProvider = null;
        this.editor = null;
        this.wspAccess = null;
    }

    @Override
    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (!this.isGranted(id, permissions)) {
            throw new AccessDeniedException("Access denied.");
        }
    }

    @Override
    public void checkPermission(Path absPath, int permissions) throws AccessDeniedException, RepositoryException {
        if (!this.isGranted(absPath, permissions)) {
            throw new AccessDeniedException("Access denied.");
        }
    }

    @Override
    public void checkRepositoryPermission(int permissions) throws AccessDeniedException, RepositoryException {
        this.checkInitialized();
        if (!this.compiledPermissions.grants(null, permissions)) {
            throw new AccessDeniedException("Access denied.");
        }
    }

    @Override
    public boolean isGranted(ItemId id, int actions) throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        if (actions == 1 && this.compiledPermissions.canReadAll()) {
            return true;
        }
        int perm = 0;
        if ((actions & 1) == 1) {
            perm |= 1;
        }
        if ((actions & 2) == 2) {
            if (id.denotesNode()) {
                perm |= 2;
                perm |= 4;
            } else {
                perm |= 2;
            }
        }
        if ((actions & 4) == 4) {
            perm |= id.denotesNode() ? 8 : 16;
        }
        Path path = this.hierMgr.getPath(id);
        return this.isGranted(path, perm);
    }

    @Override
    public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
        this.checkInitialized();
        if (!absPath.isAbsolute()) {
            throw new RepositoryException("Absolute path expected");
        }
        return this.compiledPermissions.grants(absPath, permissions);
    }

    @Override
    public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
        Path p = PathFactoryImpl.getInstance().create(parentPath, childName, true);
        return this.isGranted(p, permissions);
    }

    @Override
    public boolean canRead(Path itemPath, ItemId itemId) throws RepositoryException {
        this.checkInitialized();
        if (this.compiledPermissions.canReadAll()) {
            return true;
        }
        return this.compiledPermissions.canRead(itemPath, itemId);
    }

    @Override
    public boolean canAccess(String workspaceName) throws RepositoryException {
        this.checkInitialized();
        return this.wspAccess.canAccess(workspaceName);
    }

    @Override
    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        if (privileges == null || privileges.length == 0) {
            log.debug("No privileges passed -> allowed.");
            return true;
        }
        Path p = this.getPath(absPath);
        return this.compiledPermissions.hasPrivileges(p, privileges);
    }

    @Override
    public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        Set<Privilege> privs = this.compiledPermissions.getPrivilegeSet(this.getPath(absPath));
        return privs.toArray(new Privilege[privs.size()]);
    }

    @Override
    public AccessControlPolicy[] getPolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPermission(absPath, 32);
        AccessControlPolicy[] policies = this.editor != null ? this.editor.getPolicies(absPath) : new AccessControlPolicy[]{};
        return policies;
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPermission(absPath, 32);
        return this.acProvider.getEffectivePolicies(this.getPath(absPath), this.compiledPermissions);
    }

    @Override
    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPermission(absPath, 32);
        if (this.editor != null) {
            try {
                AccessControlPolicy[] applicable = this.editor.editAccessControlPolicies(absPath);
                return new AccessControlPolicyIteratorAdapter(Arrays.asList(applicable));
            }
            catch (AccessControlException e) {
                log.debug("No applicable policy at " + absPath);
            }
        }
        return AccessControlPolicyIteratorAdapter.EMPTY;
    }

    @Override
    public void setPolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPermission(absPath, 64);
        if (this.editor == null) {
            throw new UnsupportedRepositoryOperationException("Modification of AccessControlPolicies is not supported. ");
        }
        this.editor.setPolicy(absPath, policy);
    }

    @Override
    public void removePolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPermission(absPath, 64);
        if (this.editor == null) {
            throw new UnsupportedRepositoryOperationException("Removal of AccessControlPolicies is not supported.");
        }
        this.editor.removePolicy(absPath, policy);
    }

    @Override
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(Principal principal) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        if (this.editor == null) {
            throw new UnsupportedRepositoryOperationException("Editing of access control policies is not supported.");
        }
        return this.editor.editAccessControlPolicies(principal);
    }

    @Override
    public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        if (this.editor == null) {
            throw new UnsupportedRepositoryOperationException("Editing of access control policies is not supported.");
        }
        return this.editor.getPolicies(principal);
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        return this.acProvider.getEffectivePolicies(principals, this.compiledPermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPrivileges(String absPath, Set<Principal> principals, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        this.checkPermission(absPath, 32);
        if (privileges == null || privileges.length == 0) {
            log.debug("No privileges passed -> allowed.");
            return true;
        }
        Path p = this.getPath(absPath);
        CompiledPermissions perms = this.acProvider.compilePermissions(principals);
        try {
            boolean bl = perms.hasPrivileges(p, privileges);
            return bl;
        }
        finally {
            perms.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Privilege[] getPrivileges(String absPath, Set<Principal> principals) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        this.checkPermission(absPath, 32);
        CompiledPermissions perms = this.acProvider.compilePermissions(principals);
        try {
            Set<Privilege> privs = perms.getPrivilegeSet(this.getPath(absPath));
            Privilege[] privilegeArray = privs.toArray(new Privilege[privs.size()]);
            return privilegeArray;
        }
        finally {
            perms.close();
        }
    }

    @Override
    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    @Override
    protected void checkValidNodePath(String absPath) throws PathNotFoundException, RepositoryException {
        Path p = this.getPath(absPath);
        if (p != null) {
            if (!p.isAbsolute()) {
                throw new RepositoryException("Absolute path expected.");
            }
            if (this.hierMgr.resolveNodePath(p) == null) {
                throw new PathNotFoundException("No such node " + absPath);
            }
        }
    }

    @Override
    protected void checkPermission(String absPath, int permission) throws AccessDeniedException, RepositoryException {
        this.checkValidNodePath(absPath);
        Path p = this.getPath(absPath);
        if (!this.compiledPermissions.grants(p, permission)) {
            throw new AccessDeniedException("Access denied at " + absPath);
        }
    }

    @Override
    protected PrivilegeManager getPrivilegeManager() throws RepositoryException {
        this.checkInitialized();
        return this.privilegeManager;
    }

    private Path getPath(String absPath) throws RepositoryException {
        return absPath == null ? null : this.resolver.getQPath(absPath);
    }

    private static boolean isSystemOrAdmin(Session s) {
        if (s == null || !(s instanceof SessionImpl)) {
            return false;
        }
        SessionImpl sImpl = (SessionImpl)s;
        return sImpl.isSystem() || sImpl.isAdmin();
    }

    private class WorkspaceAccess {
        private final WorkspaceAccessManager wspAccessManager;
        private final boolean alwaysAllowed;
        private final List<String> allowed;
        private final List<String> denied;

        private WorkspaceAccess(WorkspaceAccessManager wspAccessManager, boolean alwaysAllowed) {
            this.wspAccessManager = wspAccessManager;
            this.alwaysAllowed = alwaysAllowed;
            if (!alwaysAllowed) {
                this.allowed = new ArrayList<String>(5);
                this.denied = new ArrayList<String>(5);
            } else {
                this.denied = null;
                this.allowed = null;
            }
        }

        private boolean canAccess(String workspaceName) throws RepositoryException {
            if (this.alwaysAllowed || this.wspAccessManager == null || this.allowed.contains(workspaceName)) {
                return true;
            }
            if (this.denied.contains(workspaceName)) {
                return false;
            }
            boolean canAccess = this.wspAccessManager.grants(DefaultAccessManager.this.principals, workspaceName);
            if (canAccess) {
                this.allowed.add(workspaceName);
            } else {
                this.denied.add(workspaceName);
            }
            return canAccess;
        }
    }
}

