/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractACLTemplate
implements JackrabbitAccessControlList,
AccessControlConstants {
    private static Logger log = LoggerFactory.getLogger(AbstractACLTemplate.class);
    protected final String path;
    protected final ValueFactory valueFactory;

    protected AbstractACLTemplate(String path, ValueFactory valueFactory) {
        this.path = path;
        this.valueFactory = valueFactory;
    }

    protected abstract void checkValidEntry(Principal var1, Privilege[] var2, boolean var3, Map<String, Value> var4) throws AccessControlException;

    protected abstract List<AccessControlEntry> getEntries();

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, isAllow, Collections.<String, Value>emptyMap());
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions) throws AccessControlException, RepositoryException {
        if (mvRestrictions == null || mvRestrictions.isEmpty()) {
            return this.addEntry(principal, privileges, isAllow, restrictions);
        }
        throw new UnsupportedRepositoryOperationException("Not implemented. Please use Jackrabbit OAK to get support for multi-valued restrictions.");
    }

    @Override
    public int size() {
        return this.getEntries().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getEntries().isEmpty();
    }

    @Override
    public void orderBefore(AccessControlEntry srcEntry, AccessControlEntry destEntry) throws AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        int index;
        if (srcEntry.equals(destEntry)) {
            log.debug("srcEntry equals destEntry -> no reordering required.");
            return;
        }
        List<AccessControlEntry> entries = this.getEntries();
        int n = index = destEntry == null ? entries.size() - 1 : entries.indexOf(destEntry);
        if (index < 0) {
            throw new AccessControlException("destEntry not contained in this AccessControlList");
        }
        if (!entries.remove(srcEntry)) {
            throw new AccessControlException("srcEntry not contained in this AccessControlList");
        }
        entries.add(index, srcEntry);
    }

    @Override
    public AccessControlEntry[] getAccessControlEntries() throws RepositoryException {
        List<AccessControlEntry> l = this.getEntries();
        return l.toArray(new AccessControlEntry[l.size()]);
    }

    @Override
    public boolean addAccessControlEntry(Principal principal, Privilege[] privileges) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, true, Collections.<String, Value>emptyMap());
    }
}

