/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

class SYSCOLPERMSRowFactory
extends PermissionsCatalogRowFactory {
    static final String TABLENAME_STRING = "SYSCOLPERMS";
    private static final int COLPERMSID_COL_NUM = 1;
    private static final int GRANTEE_COL_NUM = 2;
    private static final int GRANTOR_COL_NUM = 3;
    private static final int TABLEID_COL_NUM = 4;
    private static final int TYPE_COL_NUM = 5;
    protected static final int COLUMNS_COL_NUM = 6;
    private static final int COLUMN_COUNT = 6;
    static final int GRANTEE_TABLE_TYPE_GRANTOR_INDEX_NUM = 0;
    static final int COLPERMSID_INDEX_NUM = 1;
    static final int TABLEID_INDEX_NUM = 2;
    protected static final int TOTAL_NUM_OF_INDEXES = 3;
    private static final int[][] indexColumnPositions = new int[][]{{2, 4, 5, 3}, {1}, {4}};
    public static final int GRANTEE_COL_NUM_IN_GRANTEE_TABLE_TYPE_GRANTOR_INDEX = 1;
    private static final boolean[] indexUniqueness = new boolean[]{true, true, false};
    private static final String[] uuids = new String[]{"286cc01e-0103-0e39-b8e7-00000010f010", "6074401f-0103-0e39-b8e7-00000010f010", "787c0020-0103-0e39-b8e7-00000010f010", "c9a3808d-010c-42a2-ae15-0000000f67f8", "80220011-010c-bc85-060d-000000109ab8"};

    SYSCOLPERMSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(6, TABLENAME_STRING, indexColumnPositions, indexUniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        Object object;
        String string = null;
        DataValueDescriptor dataValueDescriptor = null;
        DataValueDescriptor dataValueDescriptor2 = null;
        String string2 = null;
        String string3 = null;
        FormatableBitSet formatableBitSet = null;
        if (tupleDescriptor == null) {
            dataValueDescriptor = this.getNullAuthorizationID();
            dataValueDescriptor2 = this.getNullAuthorizationID();
        } else {
            object = (ColPermsDescriptor)tupleDescriptor;
            UUID uUID = ((PermissionsDescriptor)object).getUUID();
            if (uUID == null) {
                uUID = this.getUUIDFactory().createUUID();
                ((PermissionsDescriptor)object).setUUID(uUID);
            }
            string = uUID.toString();
            dataValueDescriptor = this.getAuthorizationID(((PermissionsDescriptor)object).getGrantee());
            dataValueDescriptor2 = this.getAuthorizationID(((PermissionsDescriptor)object).getGrantor());
            string2 = ((ColPermsDescriptor)object).getTableUUID().toString();
            string3 = ((ColPermsDescriptor)object).getType();
            formatableBitSet = ((ColPermsDescriptor)object).getColumns();
        }
        object = this.getExecutionFactory().getValueRow(6);
        object.setColumn(1, new SQLChar(string));
        object.setColumn(2, dataValueDescriptor);
        object.setColumn(3, dataValueDescriptor2);
        object.setColumn(4, new SQLChar(string2));
        object.setColumn(5, new SQLChar(string3));
        object.setColumn(6, new UserType(formatableBitSet));
        return object;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        String string = execRow.getColumn(1).getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        String string2 = execRow.getColumn(4).getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string2);
        String string3 = execRow.getColumn(5).getString();
        FormatableBitSet formatableBitSet = (FormatableBitSet)execRow.getColumn(6).getObject();
        ColPermsDescriptor colPermsDescriptor = new ColPermsDescriptor(dataDictionary, this.getAuthorizationID(execRow, 2), this.getAuthorizationID(execRow, 3), uUID2, string3, formatableBitSet);
        colPermsDescriptor.setUUID(uUID);
        return colPermsDescriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("COLPERMSID", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getJavaColumn("COLUMNS", "org.apache.derby.iapi.services.io.FormatableBitSet", false)};
    }

    @Override
    public ExecIndexRow buildIndexKeyRow(int n, PermissionsDescriptor permissionsDescriptor) throws StandardException {
        ExecIndexRow execIndexRow = null;
        switch (n) {
            case 0: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(3);
                execIndexRow.setColumn(1, this.getAuthorizationID(permissionsDescriptor.getGrantee()));
                ColPermsDescriptor colPermsDescriptor = (ColPermsDescriptor)permissionsDescriptor;
                String string = colPermsDescriptor.getTableUUID().toString();
                execIndexRow.setColumn(2, new SQLChar(string));
                execIndexRow.setColumn(3, new SQLChar(colPermsDescriptor.getType()));
                break;
            }
            case 1: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(1);
                String string = permissionsDescriptor.getObjectID().toString();
                execIndexRow.setColumn(1, new SQLChar(string));
                break;
            }
            case 2: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(1);
                ColPermsDescriptor colPermsDescriptor = (ColPermsDescriptor)permissionsDescriptor;
                String string = colPermsDescriptor.getTableUUID().toString();
                execIndexRow.setColumn(1, new SQLChar(string));
            }
        }
        return execIndexRow;
    }

    @Override
    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    @Override
    public int orPermissions(ExecRow execRow, PermissionsDescriptor permissionsDescriptor, boolean[] blArray) throws StandardException {
        ColPermsDescriptor colPermsDescriptor = (ColPermsDescriptor)permissionsDescriptor;
        FormatableBitSet formatableBitSet = (FormatableBitSet)execRow.getColumn(6).getObject();
        FormatableBitSet formatableBitSet2 = colPermsDescriptor.getColumns();
        boolean bl = false;
        int n = formatableBitSet2.anySetBit();
        while (n >= 0) {
            if (!formatableBitSet.get(n)) {
                formatableBitSet.set(n);
                bl = true;
            }
            n = formatableBitSet2.anySetBit(n);
        }
        if (bl) {
            blArray[5] = true;
            return 1;
        }
        return 0;
    }

    @Override
    public int removePermissions(ExecRow execRow, PermissionsDescriptor permissionsDescriptor, boolean[] blArray) throws StandardException {
        ColPermsDescriptor colPermsDescriptor = (ColPermsDescriptor)permissionsDescriptor;
        FormatableBitSet formatableBitSet = colPermsDescriptor.getColumns();
        if (formatableBitSet == null) {
            return -1;
        }
        FormatableBitSet formatableBitSet2 = (FormatableBitSet)execRow.getColumn(6).getObject();
        boolean bl = false;
        int n = formatableBitSet.anySetBit();
        while (n >= 0) {
            if (formatableBitSet2.get(n)) {
                formatableBitSet2.clear(n);
                bl = true;
            }
            n = formatableBitSet.anySetBit(n);
        }
        if (bl) {
            blArray[5] = true;
            if (formatableBitSet2.anySetBit() < 0) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public void setUUIDOfThePassedDescriptor(ExecRow execRow, PermissionsDescriptor permissionsDescriptor) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        permissionsDescriptor.setUUID(this.getUUIDFactory().recreateUUID(dataValueDescriptor.getString()));
    }
}

