/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.AbstractBackend;
import org.apache.jackrabbit.core.data.AsyncTouchCallback;
import org.apache.jackrabbit.core.data.AsyncTouchResult;
import org.apache.jackrabbit.core.data.AsyncUploadCallback;
import org.apache.jackrabbit.core.data.AsyncUploadResult;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.LazyFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSBackend
extends AbstractBackend {
    private Properties properties;
    private String fsPath;
    File fsPathDir;
    public static final String FS_BACKEND_PATH = "fsBackendPath";
    private static final Logger LOG = LoggerFactory.getLogger(FSBackend.class);
    private static final int ACCESS_TIME_RESOLUTION = 2000;

    @Override
    public void init(CachingDataStore store, String homeDir, String config) throws DataStoreException {
        Properties initProps;
        block5: {
            block4: {
                super.init(store, homeDir, config);
                initProps = null;
                if (this.properties == null) break block4;
                initProps = this.properties;
                break block5;
            }
            initProps = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(config);
                initProps.load(in);
            }
            catch (IOException e) {
                try {
                    throw new DataStoreException("Could not initialize FSBackend from " + config, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            this.properties = initProps;
        }
        this.init(store, homeDir, initProps);
    }

    public void init(CachingDataStore store, String homeDir, Properties prop) throws DataStoreException {
        boolean created;
        this.setDataStore(store);
        this.setHomeDir(homeDir);
        this.fsPath = prop.getProperty(FS_BACKEND_PATH);
        if (this.fsPath == null || "".equals(this.fsPath)) {
            throw new DataStoreException("Could not initialize FSBackend from " + this.getConfig() + ". [" + FS_BACKEND_PATH + "] property not found.");
        }
        this.fsPathDir = new File(this.fsPath);
        if (this.fsPathDir.exists() && this.fsPathDir.isFile()) {
            throw new DataStoreException("Can not create a directory because a file exists with the same name: " + this.fsPath);
        }
        if (!this.fsPathDir.exists() && !(created = this.fsPathDir.mkdirs())) {
            throw new DataStoreException("Could not create directory: " + this.fsPathDir.getAbsolutePath());
        }
    }

    @Override
    public InputStream read(DataIdentifier identifier) throws DataStoreException {
        File file = this.getFile(identifier);
        try {
            return new LazyFileInputStream(file);
        }
        catch (IOException e) {
            throw new DataStoreException("Error opening input stream of " + file.getAbsolutePath(), e);
        }
    }

    @Override
    public long getLength(DataIdentifier identifier) throws DataStoreException {
        File file = this.getFile(identifier);
        if (file.isFile()) {
            return file.length();
        }
        throw new DataStoreException("Could not length of dataIdentifier [" + identifier + "]");
    }

    @Override
    public long getLastModified(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        File f = this.getFile(identifier);
        if (f.isFile()) {
            return FSBackend.getLastModified(f);
        }
        LOG.info("getLastModified:Identifier [{}] not found. Took [{}] ms.", (Object)identifier, (Object)(System.currentTimeMillis() - start));
        throw new DataStoreException("Identifier [" + identifier + "] not found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataIdentifier identifier, File src) throws DataStoreException {
        File dest = this.getFile(identifier);
        FSBackend fSBackend = this;
        synchronized (fSBackend) {
            if (dest.exists()) {
                long now = System.currentTimeMillis();
                if (FSBackend.getLastModified(dest) < now + 2000L) {
                    FSBackend.setLastModified(dest, now + 2000L);
                }
            } else {
                try {
                    FileUtils.copyFile((File)src, (File)dest);
                }
                catch (IOException ioe) {
                    LOG.error("failed to copy [{}] to [{}]", (Object)src.getAbsolutePath(), (Object)dest.getAbsolutePath());
                    throw new DataStoreException("Not able to write file [" + identifier + "]", ioe);
                }
            }
        }
    }

    @Override
    public void writeAsync(final DataIdentifier identifier, final File src, final AsyncUploadCallback callback) throws DataStoreException {
        if (callback == null) {
            throw new IllegalArgumentException("callback parameter cannot be null in asyncUpload");
        }
        this.getAsyncWriteExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FSBackend.this.write(identifier, src);
                    callback.onSuccess(new AsyncUploadResult(identifier, src));
                }
                catch (DataStoreException dse) {
                    AsyncUploadResult res = new AsyncUploadResult(identifier, src);
                    res.setException(dse);
                    callback.onFailure(res);
                }
            }
        });
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : this.fsPathDir.listFiles()) {
            if (!file.isDirectory()) continue;
            this.listRecursive(files, file);
        }
        ArrayList<DataIdentifier> identifiers = new ArrayList<DataIdentifier>();
        for (File f : files) {
            String name = f.getName();
            identifiers.add(new DataIdentifier(name));
        }
        LOG.debug("Found " + identifiers.size() + " identifiers.");
        return identifiers.iterator();
    }

    @Override
    public boolean exists(DataIdentifier identifier, boolean touch) throws DataStoreException {
        File file = this.getFile(identifier);
        if (file.isFile()) {
            if (touch) {
                long now = System.currentTimeMillis();
                FSBackend.setLastModified(file, now + 2000L);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean exists(DataIdentifier identifier) throws DataStoreException {
        return this.exists(identifier, false);
    }

    @Override
    public void touch(DataIdentifier identifier, long minModifiedDate) throws DataStoreException {
        File file = this.getFile(identifier);
        long now = System.currentTimeMillis();
        if (minModifiedDate > 0L && minModifiedDate > FSBackend.getLastModified(file)) {
            FSBackend.setLastModified(file, now + 2000L);
        }
    }

    @Override
    public void touchAsync(final DataIdentifier identifier, final long minModifiedDate, final AsyncTouchCallback callback) throws DataStoreException {
        try {
            if (callback == null) {
                throw new IllegalArgumentException("callback parameter cannot be null in touchAsync");
            }
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.getAsyncWriteExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FSBackend.this.touch(identifier, minModifiedDate);
                        callback.onSuccess(new AsyncTouchResult(identifier));
                    }
                    catch (DataStoreException e) {
                        AsyncTouchResult result = new AsyncTouchResult(identifier);
                        result.setException(e);
                        callback.onFailure(result);
                    }
                }
            });
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onAbort(new AsyncTouchResult(identifier));
            }
            throw new DataStoreException("Cannot touch the record " + identifier.toString(), e);
        }
    }

    @Override
    public Set<DataIdentifier> deleteAllOlderThan(long min) throws DataStoreException {
        HashSet<DataIdentifier> deleteIdSet = new HashSet<DataIdentifier>(30);
        for (File file : this.fsPathDir.listFiles()) {
            if (!file.isDirectory()) continue;
            this.deleteOlderRecursive(file, min, deleteIdSet);
        }
        return deleteIdSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        File file = this.getFile(identifier);
        FSBackend fSBackend = this;
        synchronized (fSBackend) {
            if (file.exists()) {
                if (file.delete()) {
                    this.deleteEmptyParentDirs(file);
                } else {
                    LOG.warn("Failed to delete file " + file.getAbsolutePath());
                }
            }
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private File getFile(DataIdentifier identifier) {
        String string = identifier.toString();
        File file = this.fsPathDir;
        file = new File(file, string.substring(0, 2));
        file = new File(file, string.substring(2, 4));
        file = new File(file, string.substring(4, 6));
        return new File(file, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLastModified(File file, long time) throws DataStoreException {
        if (!file.setLastModified(time)) {
            if (!file.canWrite()) {
                return;
            }
            try (RandomAccessFile r = new RandomAccessFile(file, "rw");){
                r.setLength(r.length());
            }
            catch (IOException e) {
                throw new DataStoreException("An IO Exception occurred while trying to set the last modified date: " + file.getAbsolutePath(), e);
            }
        }
    }

    private static long getLastModified(File file) throws DataStoreException {
        long lastModified = file.lastModified();
        if (lastModified == 0L) {
            throw new DataStoreException("Failed to read record modified date: " + file.getAbsolutePath());
        }
        return lastModified;
    }

    private void listRecursive(List<File> list, File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.listRecursive(list, f);
                    continue;
                }
                list.add(f);
            }
        }
    }

    private void deleteEmptyParentDirs(File file) {
        File parent = file.getParentFile();
        try {
            while (FileUtils.directoryContains((File)this.fsPathDir, (File)parent)) {
                String[] entries = parent.list();
                if (entries == null) {
                    LOG.warn("Failed to list directory {}", (Object)parent.getAbsolutePath());
                } else if (entries.length <= 0) {
                    boolean deleted = parent.delete();
                    LOG.debug("Deleted parent [{}] of file [{}]: {}", new Object[]{parent, file.getAbsolutePath(), deleted});
                    parent = parent.getParentFile();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.warn("Error in parents deletion for " + file.getAbsoluteFile(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOlderRecursive(File file, long min, Set<DataIdentifier> deleteIdSet) throws DataStoreException {
        if (file.isFile() && file.exists() && file.canWrite()) {
            FSBackend fSBackend = this;
            synchronized (fSBackend) {
                long l;
                try {
                    l = FSBackend.getLastModified(file);
                }
                catch (DataStoreException e) {
                    LOG.warn("Failed to read modification date; file not deleted", (Throwable)e);
                    l = min;
                }
                if (l < min) {
                    DataIdentifier id = new DataIdentifier(file.getName());
                    if (this.getDataStore().confirmDelete(id)) {
                        this.getDataStore().deleteFromCache(id);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Deleting old file " + file.getAbsolutePath() + " modified: " + new Timestamp(l).toString() + " length: " + file.length());
                        }
                        if (file.delete()) {
                            deleteIdSet.add(id);
                        } else {
                            LOG.warn("Failed to delete old file " + file.getAbsolutePath());
                        }
                    }
                }
            }
        }
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            if (list != null) {
                for (File f : list) {
                    this.deleteOlderRecursive(f, min, deleteIdSet);
                }
            }
            FSBackend fSBackend = this;
            synchronized (fSBackend) {
                list = file.listFiles();
                if (list != null && list.length == 0) {
                    file.delete();
                }
            }
        }
    }
}

