/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.io.IOException;
import java.security.Principal;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.apache.jackrabbit.core.security.authentication.CredentialsCallback;
import org.apache.jackrabbit.core.security.authentication.ImpersonationCallback;
import org.apache.jackrabbit.core.security.authentication.RepositoryCallback;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoginModule.class);
    private static final String KEY_CREDENTIALS = "org.apache.jackrabbit.credentials";
    private static final String KEY_LOGIN_NAME = "javax.security.auth.login.name";
    private static final String PRE_AUTHENTICATED_ATTRIBUTE_OPTION = "trust_credentials_attribute";
    private String principalProviderClassName;
    private boolean initialized;
    protected String adminId;
    protected String anonymousId;
    private String preAuthAttributeName;
    protected CallbackHandler callbackHandler;
    protected Principal principal;
    protected SimpleCredentials credentials;
    protected Subject subject;
    protected PrincipalProvider principalProvider;
    protected Map sharedState;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.sharedState = sharedState;
        try {
            Object pcOption;
            log.debug("Initialize LoginModule: ");
            RepositoryCallback repositoryCb = new RepositoryCallback();
            callbackHandler.handle(new Callback[]{repositoryCb});
            PrincipalProviderRegistry registry = repositoryCb.getPrincipalProviderRegistry();
            if (options.containsKey("principalProvider") && (pcOption = options.get("principalProvider")) != null) {
                this.principalProviderClassName = pcOption.toString();
            }
            if (this.principalProviderClassName == null) {
                if (options.containsKey("principal_provider.name")) {
                    this.principalProviderClassName = options.get("principal_provider.name").toString();
                } else if (options.containsKey("principal_provider.class")) {
                    this.principalProviderClassName = options.get("principal_provider.class").toString();
                }
            }
            if (this.principalProviderClassName != null) {
                this.principalProvider = registry.getProvider(this.principalProviderClassName);
            }
            if (this.principalProvider == null) {
                this.principalProvider = registry.getDefault();
                if (this.principalProvider == null) {
                    return;
                }
            }
            log.debug("- PrincipalProvider -> '" + this.principalProvider.getClass().getName() + "'");
            this.doInit(callbackHandler, repositoryCb.getSession(), options);
            if (options.containsKey("adminId")) {
                this.adminId = (String)options.get("adminId");
            }
            if (this.adminId == null) {
                this.adminId = repositoryCb.getAdminId();
            }
            if (options.containsKey("anonymousId")) {
                this.anonymousId = (String)options.get("anonymousId");
            }
            if (this.anonymousId == null) {
                this.anonymousId = repositoryCb.getAnonymousId();
            }
            this.preAuthAttributeName = (String)options.get(PRE_AUTHENTICATED_ATTRIBUTE_OPTION);
            if (this.preAuthAttributeName != null && this.preAuthAttributeName.length() == 0) {
                this.preAuthAttributeName = null;
            }
            if (log.isDebugEnabled()) {
                for (String option : options.keySet()) {
                    log.debug("- Option: " + option + " -> '" + options.get(option) + "'");
                }
            }
            this.initialized = this.subject != null;
        }
        catch (Exception e) {
            log.error("LoginModule failed to initialize.", (Throwable)e);
        }
    }

    protected abstract void doInit(CallbackHandler var1, Session var2, Map var3) throws LoginException;

    protected boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean login() throws LoginException {
        if (!this.isInitialized()) {
            log.warn("Unable to perform login: initialization not completed.");
            return false;
        }
        Credentials creds = this.getCredentials();
        if (creds == null) {
            log.debug("No credentials available -> try default (anonymous) authentication.");
        } else if (!this.supportsCredentials(creds)) {
            log.debug("Unsupported credentials implementation : " + creds.getClass().getName());
            return false;
        }
        try {
            Principal userPrincipal = this.getPrincipal(creds);
            if (userPrincipal == null) {
                log.debug("No valid user -> ignore.");
                return false;
            }
            boolean authenticated = this.isAnonymous(creds) || this.isPreAuthenticated(creds) ? true : (this.isImpersonation(creds) ? this.impersonate(userPrincipal, creds) : this.authenticate(userPrincipal, creds));
            if (authenticated) {
                this.credentials = creds instanceof SimpleCredentials ? (SimpleCredentials)creds : new SimpleCredentials(this.getUserID(creds), new char[0]);
                this.principal = userPrincipal;
                return true;
            }
        }
        catch (RepositoryException e) {
            log.error("Login failed:", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.isInitialized() || this.principal == null) {
            return false;
        }
        Set<Principal> principals = this.getPrincipals();
        this.subject.getPrincipals().addAll(principals);
        this.subject.getPublicCredentials().add(this.credentials);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.isInitialized()) {
            return false;
        }
        this.sharedState.remove(KEY_CREDENTIALS);
        this.callbackHandler = null;
        this.principal = null;
        this.credentials = null;
        return this.logout();
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.getPrincipals().isEmpty() || this.subject.getPublicCredentials(Credentials.class).isEmpty()) {
            return false;
        }
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().clear();
            this.subject.getPublicCredentials().clear();
        }
        return true;
    }

    protected boolean authenticate(Principal principal, Credentials credentials) throws FailedLoginException, RepositoryException {
        Authentication auth = this.getAuthentication(principal, credentials);
        if (auth == null) {
            return false;
        }
        if (auth.authenticate(credentials)) {
            return true;
        }
        throw new FailedLoginException();
    }

    protected boolean isImpersonation(Credentials credentials) {
        return this.getImpersonatorSubject(credentials) != null;
    }

    protected abstract boolean impersonate(Principal var1, Credentials var2) throws RepositoryException, LoginException;

    protected abstract Authentication getAuthentication(Principal var1, Credentials var2) throws RepositoryException;

    protected Subject getImpersonatorSubject(Credentials credentials) {
        Subject impersonator = null;
        if (credentials == null) {
            try {
                ImpersonationCallback impers = new ImpersonationCallback();
                this.callbackHandler.handle(new Callback[]{impers});
                impersonator = impers.getImpersonator();
            }
            catch (UnsupportedCallbackException e) {
                log.warn(e.getCallback().getClass().getName() + " not supported: Unable to perform Impersonation.");
            }
            catch (IOException e) {
                log.error("Impersonation-Callback failed: " + e.getMessage() + ": Unable to perform Impersonation.");
            }
        } else if (credentials instanceof SimpleCredentials) {
            SimpleCredentials sc = (SimpleCredentials)credentials;
            impersonator = (Subject)sc.getAttribute("org.apache.jackrabbit.core.security.impersonator");
        }
        return impersonator;
    }

    protected Credentials getCredentials() {
        Set<Credentials> preAuthCreds;
        Credentials credentials = null;
        if (this.sharedState.containsKey(KEY_CREDENTIALS)) {
            credentials = (Credentials)this.sharedState.get(KEY_CREDENTIALS);
        } else {
            try {
                CredentialsCallback callback = new CredentialsCallback();
                this.callbackHandler.handle(new Callback[]{callback});
                credentials = callback.getCredentials();
                if (credentials != null && this.supportsCredentials(credentials)) {
                    this.sharedState.put(KEY_CREDENTIALS, credentials);
                }
            }
            catch (UnsupportedCallbackException e) {
                log.warn("Credentials-Callback not supported try Name-Callback");
            }
            catch (IOException e) {
                log.error("Credentials-Callback failed: " + e.getMessage() + ": try Name-Callback");
            }
        }
        if (null == credentials && !(preAuthCreds = this.subject.getPublicCredentials(SimpleCredentials.class)).isEmpty()) {
            credentials = preAuthCreds.iterator().next();
        }
        if (null == credentials && !(preAuthCreds = this.subject.getPublicCredentials(GuestCredentials.class)).isEmpty()) {
            credentials = preAuthCreds.iterator().next();
        }
        return credentials;
    }

    protected boolean supportsCredentials(Credentials creds) {
        return creds instanceof SimpleCredentials || creds instanceof GuestCredentials;
    }

    protected String getUserID(Credentials credentials) {
        String userId = null;
        if (credentials != null) {
            if (credentials instanceof GuestCredentials) {
                userId = this.anonymousId;
            } else if (credentials instanceof SimpleCredentials) {
                userId = ((SimpleCredentials)credentials).getUserID();
            } else {
                try {
                    NameCallback callback = new NameCallback("User-ID: ");
                    this.callbackHandler.handle(new Callback[]{callback});
                    userId = callback.getName();
                }
                catch (UnsupportedCallbackException e) {
                    log.warn("Credentials- or NameCallback must be supported");
                }
                catch (IOException e) {
                    log.error("Name-Callback failed: " + e.getMessage());
                }
            }
        }
        if (userId == null && this.sharedState.containsKey(KEY_LOGIN_NAME)) {
            userId = (String)this.sharedState.get(KEY_LOGIN_NAME);
        }
        if (userId == null) {
            userId = this.anonymousId;
        }
        return userId;
    }

    protected boolean isAnonymous(Credentials credentials) {
        if (credentials instanceof GuestCredentials) {
            return true;
        }
        String userId = this.getUserID(credentials);
        return this.anonymousId == null ? userId == null : this.anonymousId.equals(userId);
    }

    protected abstract Principal getPrincipal(Credentials var1);

    protected Set<Principal> getPrincipals() {
        LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>();
        principals.add(this.principal);
        PrincipalIterator groups = this.principalProvider.getGroupMembership(this.principal);
        while (groups.hasNext()) {
            principals.add(groups.nextPrincipal());
        }
        return principals;
    }

    public String getAdminId() {
        return this.adminId;
    }

    public void setAdminId(String adminId) {
        this.adminId = adminId;
    }

    public String getAnonymousId() {
        return this.anonymousId;
    }

    public void setAnonymousId(String anonymousId) {
        this.anonymousId = anonymousId;
    }

    public String getPrincipalProvider() {
        return this.principalProviderClassName;
    }

    public void setPrincipalProvider(String principalProvider) {
        this.principalProviderClassName = principalProvider;
    }

    protected final String getPreAuthAttributeName() {
        return this.preAuthAttributeName;
    }

    protected boolean isPreAuthenticated(Credentials creds) {
        boolean isPreAuth;
        String preAuthAttrName = this.getPreAuthAttributeName();
        boolean bl = isPreAuth = preAuthAttrName != null && creds instanceof SimpleCredentials && ((SimpleCredentials)creds).getAttribute(preAuthAttrName) != null;
        if (isPreAuth) {
            log.warn("Usage of deprecated 'trust_credentials_attribute' option. Please note that for security reasons this feature will notbe supported in future releases.");
        }
        return isPreAuth;
    }
}

