/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.session;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.stats.RepositoryStatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionState {
    private static final Logger log = LoggerFactory.getLogger(SessionState.class);
    private final SessionContext context;
    private final AtomicLong readCounter;
    private final AtomicLong writeCounter;
    private final AtomicLong readDuration;
    private final AtomicLong writeDuration;
    private final AtomicLong sessionCount;
    private final Lock lock = new ReentrantLock();
    private volatile boolean isWriteOperation = false;
    private volatile Exception closed = null;

    public SessionState(SessionContext context) {
        this.context = context;
        RepositoryStatisticsImpl statistics = context.getRepositoryContext().getRepositoryStatistics();
        this.readCounter = statistics.getCounter(RepositoryStatistics.Type.SESSION_READ_COUNTER);
        this.writeCounter = statistics.getCounter(RepositoryStatistics.Type.SESSION_WRITE_COUNTER);
        this.readDuration = statistics.getCounter(RepositoryStatistics.Type.SESSION_READ_DURATION);
        this.writeDuration = statistics.getCounter(RepositoryStatistics.Type.SESSION_WRITE_DURATION);
        this.sessionCount = statistics.getCounter(RepositoryStatistics.Type.SESSION_COUNT);
        statistics.getCounter(RepositoryStatistics.Type.SESSION_LOGIN_COUNTER).incrementAndGet();
        this.sessionCount.incrementAndGet();
    }

    public boolean isAlive() {
        return this.closed == null;
    }

    public void checkAlive() throws RepositoryException {
        if (!this.isAlive()) {
            throw new RepositoryException("This session has been closed. See the chained exception for a trace of where the session was closed.", this.closed);
        }
    }

    /*
     * Exception decompiling
     */
    public <T> T perform(SessionOperation<T> operation) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        Exception trace2;
        String session = this.context.getSessionImpl().toString();
        if (!this.lock.tryLock()) {
            trace2 = new Exception("Stack trace of concurrent access to " + session);
            log.warn("Attempt to close " + session + " while another thread is concurrently accessing this session. Blocking until the other thread is finished using this session. Please review your code to avoid concurrent use of a session.", (Throwable)trace2);
            this.lock.lock();
        }
        try {
            if (this.isAlive()) {
                this.sessionCount.decrementAndGet();
                this.closed = new Exception("Stack trace of  where " + session + " was originally closed");
                boolean trace2 = true;
                return trace2;
            }
            trace2 = new Exception("Stack trace of the duplicate attempt to close " + session);
            log.warn("Attempt to close " + session + " after it has already been closed. Please review your code for proper session management.", (Throwable)trace2);
            log.warn(session + " has already been closed. See the attached exception for a trace of where this session was closed.", (Throwable)this.closed);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

