/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import javax.servlet.http.HttpServletRequest;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpMessage;

public class JettyRestHttpBinding
extends DefaultHttpBinding {
    @Deprecated
    public JettyRestHttpBinding() {
    }

    public JettyRestHttpBinding(HttpCommonEndpoint ep) {
        super(ep);
        this.setHeaderFilterStrategy(ep.getHeaderFilterStrategy());
        this.setTransferException(ep.isTransferException());
        this.setEagerCheckContentAvailable(ep.isEagerCheckContentAvailable());
        this.setMapHttpMessageBody(ep.isMapHttpMessageBody());
        this.setMapHttpMessageHeaders(ep.isMapHttpMessageHeaders());
    }

    @Override
    protected void populateRequestParameters(HttpServletRequest request, HttpMessage message) {
        super.populateRequestParameters(request, message);
        String path = request.getPathInfo();
        if (path == null) {
            return;
        }
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)message.getExchange().getFromEndpoint();
        String consumerPath = endpoint.getPath();
        if (this.useRestMatching(consumerPath)) {
            String[] paths = path.split("/");
            String[] consumerPaths = consumerPath.split("/");
            for (int i = 0; i < consumerPaths.length && paths.length >= i; ++i) {
                String p1 = consumerPaths[i];
                if (!p1.startsWith("{") || !p1.endsWith("}")) continue;
                String key = p1.substring(1, p1.length() - 1);
                String value = paths[i];
                if (value == null) continue;
                message.setHeader(key, value);
            }
        }
    }

    private boolean useRestMatching(String path) {
        return path.indexOf(123) > -1;
    }
}

