/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty9;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.StreamCache;
import org.apache.camel.component.jetty.JettyContentExchange;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty9.CamelInputStreamContentProvider;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyContentExchange9
implements JettyContentExchange {
    private static final Logger LOG = LoggerFactory.getLogger(JettyContentExchange9.class);
    private volatile Exchange exchange;
    private volatile AsyncCallback callback;
    private volatile JettyHttpBinding jettyBinding;
    private volatile HttpClient client;
    private final CountDownLatch done = new CountDownLatch(1);
    private Request request;
    private Response response;
    private byte[] responseContent;
    private String requestContentType;
    private boolean supportRedirect;

    @Override
    public void init(Exchange exchange, JettyHttpBinding jettyBinding, HttpClient client, AsyncCallback callback) {
        this.exchange = exchange;
        this.jettyBinding = jettyBinding;
        this.client = client;
        this.callback = callback;
    }

    protected void onRequestComplete() {
        LOG.trace("onRequestComplete");
        this.closeRequestContentSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onResponseComplete(Result result, byte[] content) {
        LOG.trace("onResponseComplete");
        this.done.countDown();
        this.response = result.getResponse();
        this.responseContent = content;
        if (this.callback == null) {
            return;
        }
        try {
            this.jettyBinding.populateResponse(this.exchange, this);
        }
        catch (Exception e) {
            this.exchange.setException(e);
        }
        finally {
            this.callback.done(false);
        }
    }

    protected void onExpire() {
        LOG.trace("onExpire");
        this.closeRequestContentSource();
        this.doTaskCompleted(new ExchangeTimedOutException(this.exchange, this.client.getConnectTimeout()));
    }

    protected void onException(Throwable ex) {
        LOG.trace("onException {}", (Object)ex.getMessage(), (Object)ex);
        this.closeRequestContentSource();
        this.doTaskCompleted(ex);
    }

    protected void onConnectionFailed(Throwable ex) {
        LOG.trace("onConnectionFailed {}", (Object)ex.getMessage(), (Object)ex);
        this.closeRequestContentSource();
        this.doTaskCompleted(ex);
    }

    @Override
    public byte[] getBody() {
        return this.getResponseContentBytes();
    }

    @Override
    public String getUrl() {
        try {
            return this.request.getURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected void closeRequestContentSource() {
        this.tryClose(this.request.getContent());
    }

    private void tryClose(Object obj) {
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void doTaskCompleted(Throwable ex) {
        if (ex instanceof TimeoutException) {
            this.exchange.setException(new ExchangeTimedOutException(this.exchange, this.request.getTimeout()));
        } else {
            this.exchange.setException(new CamelExchangeException("JettyClient failed cause by: " + ex.getMessage(), this.exchange, ex));
        }
        this.done.countDown();
        if (this.callback != null) {
            this.callback.done(false);
        }
    }

    @Override
    public void setRequestContentType(String contentType) {
        this.requestContentType = contentType;
    }

    @Override
    public int getResponseStatus() {
        return this.response.getStatus();
    }

    @Override
    public void setMethod(String method) {
        this.request.method(method);
    }

    @Override
    public void setTimeout(long timeout) {
        this.request.timeout(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setURL(String url) {
        this.request = this.client.newRequest(url);
    }

    @Override
    public void setRequestContent(byte[] byteArray) {
        this.request.content(new BytesContentProvider(new byte[][]{byteArray}), this.requestContentType);
    }

    @Override
    public void setRequestContent(String data, String charset) throws UnsupportedEncodingException {
        StringContentProvider cp = charset != null ? new StringContentProvider(data, charset) : new StringContentProvider(data);
        this.request.content(cp, this.requestContentType);
    }

    @Override
    public void setRequestContent(InputStream ins) {
        this.request.content(new InputStreamContentProvider(ins), this.requestContentType);
    }

    @Override
    public void setRequestContent(InputStream ins, int contentLength) {
        this.request.content(new CamelInputStreamContentProvider(ins, contentLength), this.requestContentType);
    }

    @Override
    public void addRequestHeader(String key, String s) {
        this.request.header(key, s);
    }

    @Override
    public void send(HttpClient client) throws IOException {
        Request.Listener.Adapter listener = new Request.Listener.Adapter(){

            @Override
            public void onSuccess(Request request) {
                JettyContentExchange9.this.onRequestComplete();
            }

            @Override
            public void onFailure(Request request, Throwable failure) {
                JettyContentExchange9.this.onConnectionFailed(failure);
            }
        };
        InputStreamResponseListener responseListener = new InputStreamResponseListener(){
            OutputStreamBuilder osb;
            {
                this.osb = OutputStreamBuilder.withExchange(JettyContentExchange9.this.exchange);
            }

            @Override
            public void onContent(Response response, ByteBuffer content, Callback callback) {
                byte[] buffer = new byte[content.limit()];
                content.get(buffer);
                try {
                    this.osb.write(buffer);
                    callback.succeeded();
                }
                catch (IOException e) {
                    callback.failed(e);
                }
            }

            @Override
            public void onComplete(Result result) {
                if (result.isFailed()) {
                    JettyContentExchange9.this.doTaskCompleted(result.getFailure());
                } else {
                    try {
                        Object content = this.osb.build();
                        if (content instanceof byte[]) {
                            JettyContentExchange9.this.onResponseComplete(result, (byte[])content);
                        } else {
                            StreamCache cos = (StreamCache)content;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            cos.writeTo(baos);
                            JettyContentExchange9.this.onResponseComplete(result, baos.toByteArray());
                        }
                    }
                    catch (IOException e) {
                        JettyContentExchange9.this.doTaskCompleted(e);
                    }
                }
            }
        };
        this.request.followRedirects(this.supportRedirect).listener(listener).send(responseListener);
    }

    protected void setResponse(Response response) {
        this.response = response;
    }

    @Override
    public byte[] getResponseContentBytes() {
        return this.responseContent;
    }

    private Map<String, Collection<String>> getFieldsAsMap(HttpFields fields) {
        TreeMap<String, Collection<String>> result = new TreeMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
        for (String name : this.getFieldNamesCollection(fields)) {
            result.put(name, fields.getValuesList(name));
        }
        return result;
    }

    private Collection<String> getFieldNamesCollection(HttpFields fields) {
        try {
            return fields.getFieldNamesCollection();
        }
        catch (NoSuchMethodError e) {
            try {
                Method reflGetFieldNamesCollection = HttpFields.class.getMethod("getFieldNamesCollection", new Class[0]);
                Object result = reflGetFieldNamesCollection.invoke((Object)fields, new Object[0]);
                return (Collection)result;
            }
            catch (Exception reflectionException) {
                throw e;
            }
        }
    }

    @Override
    public Map<String, Collection<String>> getRequestHeaders() {
        return this.getFieldsAsMap(this.request.getHeaders());
    }

    @Override
    public Map<String, Collection<String>> getResponseHeaders() {
        return this.getFieldsAsMap(this.response.getHeaders());
    }

    @Override
    public void setSupportRedirect(boolean supportRedirect) {
        this.supportRedirect = supportRedirect;
    }
}

