/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty9;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jetty.JettyHttpComponent;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.component.jetty9.JettyHttpEndpoint9;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.PropertyBindingSupport;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="jetty")
public class JettyHttpComponent9
extends JettyHttpComponent {
    public static Map<String, Throwable> connectorCreation = new ConcurrentHashMap<String, Throwable>();
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpComponent9.class);

    @Override
    protected JettyHttpEndpoint createEndpoint(URI endpointUri, URI httpUri) throws URISyntaxException {
        return new JettyHttpEndpoint9(this, endpointUri.toString(), httpUri);
    }

    @Override
    protected AbstractConnector createConnectorJettyInternal(Server server, JettyHttpEndpoint endpoint, SslContextFactory sslcf) {
        try {
            String host = endpoint.getHttpUri().getHost();
            int port = endpoint.getPort();
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSendServerVersion(endpoint.isSendServerVersion());
            httpConfig.setSendDateHeader(endpoint.isSendDateHeader());
            if (this.requestBufferSize != null) {
                // empty if block
            }
            if (this.requestHeaderSize != null) {
                httpConfig.setRequestHeaderSize(this.requestHeaderSize);
            }
            if (this.responseBufferSize != null) {
                httpConfig.setOutputBufferSize(this.responseBufferSize);
            }
            if (this.responseHeaderSize != null) {
                httpConfig.setResponseHeaderSize(this.responseHeaderSize);
            }
            if (this.useXForwardedForHeader) {
                httpConfig.addCustomizer(new ForwardedRequestCustomizer());
            }
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
            ArrayList<Object> connectionFactories = new ArrayList<Object>();
            ServerConnector result = new ServerConnector(server);
            if (sslcf != null) {
                httpConfig.addCustomizer(new SecureRequestCustomizer());
                SslConnectionFactory scf = new SslConnectionFactory(sslcf, "HTTP/1.1");
                connectionFactories.add(scf);
                result.setDefaultProtocol(scf.getProtocol());
            }
            connectionFactories.add(httpFactory);
            for (ConnectionFactory connectionFactory : connectionFactories) {
                result.addConnectionFactory(connectionFactory);
            }
            result.setPort(port);
            if (host != null) {
                result.setHost(host);
            }
            if (sslcf != null) {
                if (this.getSslSocketConnectorProperties() != null && "https".equals(endpoint.getProtocol())) {
                    HashMap<String, Object> properties = new HashMap<String, Object>(this.getSslSocketConnectorProperties());
                    PropertyBindingSupport.bindProperties(this.getCamelContext(), sslcf, properties);
                    if (properties.size() > 0) {
                        throw new IllegalArgumentException("There are " + properties.size() + " parameters that couldn't be set on the SocketConnector. Check the uri if the parameters are spelt correctly and that they are properties of the SelectChannelConnector. Unknown parameters=[" + properties + "]");
                    }
                }
                LOG.info("Connector on port: {} is using includeCipherSuites: {} excludeCipherSuites: {} includeProtocols: {} excludeProtocols: {}", new Object[]{port, sslcf.getIncludeCipherSuites(), sslcf.getExcludeCipherSuites(), sslcf.getIncludeProtocols(), sslcf.getExcludeProtocols()});
            }
            String ckey = endpoint.getProtocol() + ":" + endpoint.getHttpUri().getHost() + ":" + endpoint.getPort();
            connectorCreation.computeIfAbsent(ckey, c -> new Throwable());
            return result;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }
}

