/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty9;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachment;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpMessage;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AttachmentHttpBinding
extends DefaultHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentHttpBinding.class);

    AttachmentHttpBinding() {
    }

    @Override
    protected void populateAttachments(HttpServletRequest request, HttpMessage message) {
        Boolean object = (Boolean)request.getAttribute("populate.multipart");
        if (object != null && object.booleanValue()) {
            try {
                Collection<Part> parts = request.getParts();
                for (Part part : parts) {
                    PartDataSource ds = new PartDataSource(part);
                    DefaultAttachment attachment = new DefaultAttachment(ds);
                    for (String headerName : part.getHeaderNames()) {
                        for (String headerValue : part.getHeaders(headerName)) {
                            attachment.addHeader(headerName, headerValue);
                        }
                    }
                    AttachmentMessage am = message.getExchange().getMessage(AttachmentMessage.class);
                    am.addAttachmentObject(part.getName(), attachment);
                    String name = part.getSubmittedFileName();
                    DataHandler value = am.getAttachment(name);
                    Map<String, Object> headers = message.getHeaders();
                    if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, value, message.getExchange()) || name == null) continue;
                    HttpHelper.appendHeader(headers, name, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot populate attachments", e);
            }
        }
    }

    @Override
    protected void populateRequestParameters(HttpServletRequest request, HttpMessage message) {
        Map<String, Object> headers = message.getHeaders();
        if (request instanceof Request) {
            Request jettyRequest = (Request)request;
            jettyRequest.getHttpFields().remove("Content-Encoding");
        }
        AttachmentMessage am = message.getExchange().getMessage(AttachmentMessage.class);
        Enumeration<String> names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if (am != null && am.getAttachment(name) != null) {
                DataHandler dh = am.getAttachment(name);
                Object value = dh;
                if (dh.getContentType() == null || dh.getContentType().startsWith("text/plain")) {
                    value = request.getParameter(name);
                }
                if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, value, message.getExchange())) continue;
                HttpHelper.appendHeader(headers, name, value);
                continue;
            }
            String[] values = request.getParameterValues(name);
            LOG.trace("HTTP parameter {} = {}", (Object)name, (Object)values);
            if (values == null) continue;
            for (String value : values) {
                if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, value, message.getExchange())) continue;
                HttpHelper.appendHeader(headers, name, value);
            }
        }
    }

    static final class PartDataSource
    implements DataSource {
        private final Part part;

        PartDataSource(Part part) {
            this.part = part;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        @Override
        public String getName() {
            return this.part.getName();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        @Override
        public String getContentType() {
            return this.part.getContentType();
        }
    }
}

