/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpRegistry;
import org.apache.camel.http.common.HttpRegistryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpRegistry
implements HttpRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpRegistry.class);
    private static Map<String, HttpRegistry> registries = new HashMap<String, HttpRegistry>();
    private final Object lock = new Object();
    private final Set<HttpConsumer> consumers = new HashSet<HttpConsumer>();
    private final Set<HttpRegistryProvider> providers = new HashSet<HttpRegistryProvider>();

    public static synchronized HttpRegistry getHttpRegistry(String name) {
        return registries.computeIfAbsent(name, k -> new DefaultHttpRegistry());
    }

    public static synchronized void removeHttpRegistry(String name) {
        registries.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(HttpConsumer consumer) {
        Object object = this.lock;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering consumer for path {} providers present: {}", (Object)consumer.getPath(), (Object)this.providers.size());
            }
            this.consumers.add(consumer);
            for (HttpRegistryProvider provider : this.providers) {
                provider.connect(consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(HttpConsumer consumer) {
        Object object = this.lock;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregistering consumer for path {}", (Object)consumer.getPath());
            }
            this.consumers.remove(consumer);
            for (HttpRegistryProvider provider : this.providers) {
                provider.disconnect(consumer);
            }
        }
    }

    public void register(CamelServlet provider, Map properties) {
        CamelServlet camelServlet = provider;
        camelServlet.setServletName((String)properties.get("servlet-name"));
        this.register(camelServlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(HttpRegistryProvider provider) {
        Object object = this.lock;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering CamelServlet with name {} consumers present: {}", (Object)provider.getServletName(), (Object)this.consumers.size());
            }
            this.providers.add(provider);
            for (HttpConsumer consumer : this.consumers) {
                provider.connect(consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(HttpRegistryProvider provider) {
        Object object = this.lock;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregistering CamelServlet with name {}", (Object)provider.getServletName());
            }
            this.providers.remove(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpRegistryProvider getCamelServlet(String servletName) {
        Object object = this.lock;
        synchronized (object) {
            for (HttpRegistryProvider provider : this.providers) {
                if (!provider.getServletName().equals(servletName)) continue;
                return provider;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServlets(List<Servlet> servlets) {
        Object object = this.lock;
        synchronized (object) {
            this.providers.clear();
            for (Servlet servlet : servlets) {
                if (!(servlet instanceof HttpRegistryProvider)) continue;
                this.providers.add((HttpRegistryProvider)((Object)servlet));
            }
        }
    }
}

