/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.util.ObjectHelper;

public class HttpMessage
extends DefaultMessage {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpCommonEndpoint endpoint;
    private boolean requestRead;

    public HttpMessage(Exchange exchange, HttpCommonEndpoint endpoint, HttpServletRequest request, HttpServletResponse response) {
        super(exchange);
        this.init(exchange, endpoint, request, response);
    }

    private HttpMessage(HttpServletRequest request, HttpServletResponse response, Exchange exchange, HttpCommonEndpoint endpoint, boolean requestRead) {
        super(exchange);
        this.request = request;
        this.response = response;
        this.endpoint = endpoint;
        this.requestRead = requestRead;
    }

    public void init(Exchange exchange, HttpCommonEndpoint endpoint, HttpServletRequest request, HttpServletResponse response) {
        this.setExchange(exchange);
        this.requestRead = false;
        this.endpoint = endpoint;
        this.request = request;
        this.response = response;
        this.setHeader("CamelHttpServletRequest", request);
        this.setHeader("CamelHttpServletResponse", response);
        Boolean flag = exchange.getProperty("CamelSkipWwwFormUrlEncoding", Boolean.class);
        if (flag != null && flag.booleanValue()) {
            this.setHeader("CamelSkipWwwFormUrlEncoding", Boolean.TRUE);
        }
        endpoint.getHttpBinding().readRequest(request, this);
    }

    @Override
    public void reset() {
        super.reset();
        this.request = null;
        this.response = null;
        this.endpoint = null;
        this.requestRead = false;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    protected Object createBody() {
        if (this.requestRead) {
            return null;
        }
        try {
            Object object = this.endpoint.getHttpBinding().parseBody(this);
            return object;
        }
        catch (IOException e) {
            throw new RuntimeCamelException(e);
        }
        finally {
            this.requestRead = true;
        }
    }

    @Override
    public HttpMessage newInstance() {
        return new HttpMessage(this.request, this.response, this.getExchange(), this.endpoint, this.requestRead);
    }

    @Override
    public String toString() {
        return "HttpMessage@" + ObjectHelper.getIdentityHashCode(this);
    }
}

