/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class CamelFilterWrapper
implements Filter {
    private Filter wrapped;

    public CamelFilterWrapper(Filter wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute("CamelExchange") == null) {
            this.wrapped.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {
        this.wrapped.destroy();
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        Object o = config.getServletContext().getAttribute("javax.servlet.context.tempdir");
        if (o == null) {
            try {
                File file = File.createTempFile("camel", "");
                file.delete();
                config.getServletContext().setAttribute("javax.servlet.context.tempdir", file.getParentFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.wrapped.init(config);
    }
}

