/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty9;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.camel.Attachment;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.impl.DefaultAttachment;
import org.eclipse.jetty.util.MultiPartInputStreamParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AttachmentHttpBinding
extends DefaultHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentHttpBinding.class);

    AttachmentHttpBinding() {
    }

    @Override
    protected void populateAttachments(HttpServletRequest request, HttpMessage message) {
        Object object = request.getAttribute("org.eclipse.jetty.servlet.MultiPartFile.multiPartInputStream");
        if (object instanceof MultiPartInputStreamParser) {
            MultiPartInputStreamParser parser = (MultiPartInputStreamParser)object;
            try {
                Collection<Part> parts = parser.getParts();
                for (Part part : parts) {
                    PartDataSource ds = new PartDataSource(part);
                    DefaultAttachment attachment = new DefaultAttachment((DataSource)ds);
                    for (String headerName : part.getHeaderNames()) {
                        for (String headerValue : part.getHeaders(headerName)) {
                            attachment.addHeader(headerName, headerValue);
                        }
                    }
                    message.addAttachmentObject(part.getName(), (Attachment)attachment);
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot populate attachments", (Throwable)e);
            }
        }
    }

    @Override
    protected void populateRequestParameters(HttpServletRequest request, HttpMessage message) throws Exception {
        Map headers = message.getHeaders();
        Enumeration<String> names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if (message.getAttachment(name) != null) {
                DataHandler dh;
                Object value = dh = message.getAttachment(name);
                if (dh.getContentType() == null || dh.getContentType().startsWith("text/plain")) {
                    value = request.getParameter(name);
                }
                if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, value, message.getExchange())) continue;
                HttpHelper.appendHeader(headers, name, value);
                continue;
            }
            String[] values = request.getParameterValues(name);
            LOG.trace("HTTP parameter {} = {}", (Object)name, (Object)values);
            if (values == null) continue;
            for (String value : values) {
                if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                HttpHelper.appendHeader(headers, name, value);
            }
        }
    }

    final class PartDataSource
    implements DataSource {
        private final Part part;

        PartDataSource(Part part) {
            this.part = part;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getName() {
            return this.part.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        public String getContentType() {
            return this.part.getContentType();
        }
    }
}

