/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups;

import org.apache.camel.Exchange;
import org.apache.camel.component.jgroups.JGroupsEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.jgroups.Address;
import org.jgroups.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsProducer.class);
    private final JGroupsEndpoint endpoint;
    private final String clusterName;

    public JGroupsProducer(JGroupsEndpoint endpoint, String clusterName) {
        super(endpoint);
        this.endpoint = endpoint;
        this.clusterName = clusterName;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.connect();
    }

    @Override
    protected void doStop() throws Exception {
        this.endpoint.disconnect();
        super.doStop();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Object body = exchange.getIn().getBody();
        if (body != null) {
            Address destinationAddress = exchange.getIn().getHeader("JGROUPS_DEST", Address.class);
            Address sourceAddress = exchange.getIn().getHeader("JGROUPS_SRC", Address.class);
            LOG.debug("Posting: {} to cluster: {}", body, (Object)this.clusterName);
            if (destinationAddress != null) {
                LOG.debug("Posting to custom destination address: {}", (Object)destinationAddress);
            }
            if (sourceAddress != null) {
                LOG.debug("Posting from custom source address: {}", (Object)sourceAddress);
            }
            Message message = new Message(destinationAddress, body);
            message.setSrc(sourceAddress);
            this.endpoint.getResolvedChannel().send(message);
        } else {
            LOG.debug("Body is null, cannot post to channel.");
        }
    }
}

