/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import org.apache.camel.CamelContext;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.apache.camel.util.ObjectHelper;
import org.jgroups.JChannel;
import org.jgroups.blocks.locking.LockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsLockClusterView
extends AbstractCamelClusterView {
    private static final transient Logger LOG = LoggerFactory.getLogger(JGroupsLockClusterView.class);
    private final CamelClusterMember localMember = new JGropusLocalMember();
    private String jgroupsConfig;
    private String jgroupsClusterName;
    private String lockName;
    private JChannel channel;
    private LockService lockService;
    private Lock lock;
    private ScheduledExecutorService executor;
    private volatile boolean isMaster;

    protected JGroupsLockClusterView(CamelClusterService cluster, String namespace, String jgroupsConfig, String jgroupsClusterName) {
        super(cluster, namespace);
        this.lockName = namespace;
        this.jgroupsConfig = jgroupsConfig;
        this.jgroupsClusterName = jgroupsClusterName;
    }

    @Override
    public Optional<CamelClusterMember> getLeader() {
        if (this.isMaster) {
            return Optional.of(this.localMember);
        }
        return Optional.empty();
    }

    @Override
    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    @Override
    public List<CamelClusterMember> getMembers() {
        return new ArrayList<CamelClusterMember>(){
            {
                this.add(JGroupsLockClusterView.this.localMember);
            }
        };
    }

    @Override
    protected void doStart() throws Exception {
        if (this.lock != null) {
            this.lock.unlock();
            this.lock = null;
        }
        if (this.channel == null) {
            this.channel = new JChannel(this.jgroupsConfig);
            this.lockService = new LockService(this.channel);
        }
        this.channel.connect(this.jgroupsClusterName);
        this.lock = this.lockService.getLock(this.lockName);
        CamelContext context = ObjectHelper.notNull(this.getCamelContext(), "CamelContext");
        this.executor = context.getExecutorServiceManager().newSingleThreadScheduledExecutor(this, "JGroupsLockClusterView-" + this.getClusterService().getId() + "-" + this.lockName);
        this.executor.execute(() -> {
            LOG.info("Attempting to become master acquiring the lock for group: {} in JGroups cluster {} with configuration: {}", new Object[]{this.lockName, this.jgroupsClusterName, this.jgroupsConfig});
            this.lock.lock();
            this.isMaster = true;
            this.fireLeadershipChangedEvent(Optional.ofNullable(this.localMember));
            LOG.info("Became master by acquiring the lock for group: {} in JGroups cluster {} with configuration: {}", new Object[]{this.lockName, this.jgroupsClusterName, this.jgroupsConfig});
        });
    }

    @Override
    protected void doStop() throws Exception {
        this.shutdownExecutor();
        this.isMaster = false;
        this.fireLeadershipChangedEvent(Optional.empty());
        this.clearLock();
        this.channel.disconnect();
    }

    @Override
    protected void doShutdown() throws Exception {
        this.shutdownExecutor();
        this.isMaster = false;
        this.fireLeadershipChangedEvent(Optional.empty());
        this.clearLock();
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    private void clearLock() {
        if (this.lock != null) {
            this.lock.unlock();
            this.lock = null;
        }
    }

    private void shutdownExecutor() {
        CamelContext context = this.getCamelContext();
        if (this.executor != null) {
            if (context != null) {
                context.getExecutorServiceManager().shutdown(this.executor);
            } else {
                this.executor.shutdown();
            }
            this.executor = null;
        }
    }

    private final class JGropusLocalMember
    implements CamelClusterMember {
        private JGropusLocalMember() {
        }

        @Override
        public boolean isLeader() {
            return JGroupsLockClusterView.this.isMaster;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public String getId() {
            return JGroupsLockClusterView.this.getClusterService().getId();
        }
    }
}

