/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jgroups.JGroupsConsumer;
import org.apache.camel.component.jgroups.JGroupsEndpoint;
import org.apache.camel.component.jgroups.JGroupsException;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelJGroupsReceiver
extends ReceiverAdapter {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelJGroupsReceiver.class);
    private final JGroupsConsumer consumer;
    private final JGroupsEndpoint endpoint;
    private final AsyncProcessor processor;

    public CamelJGroupsReceiver(JGroupsConsumer consumer, JGroupsEndpoint endpoint, Processor processor) {
        this.consumer = consumer;
        this.endpoint = endpoint;
        this.processor = AsyncProcessorConverterHelper.convert(processor);
    }

    @Override
    public void viewAccepted(View view) {
        if (this.endpoint.isEnableViewMessages()) {
            Exchange exchange = this.createExchange(view);
            try {
                LOG.debug("Processing view: {}", (Object)view);
                this.processor.process(exchange, new AsyncCallback(){

                    @Override
                    public void done(boolean doneSync) {
                    }
                });
            }
            catch (Exception e) {
                throw new JGroupsException("Error in consumer while dispatching exchange containing view " + view, e);
            }
        } else {
            LOG.debug("Option enableViewMessages is set to false. Skipping processing of the view: {}", (Object)view);
        }
    }

    @Override
    public void receive(Message message) {
        Exchange exchange = this.endpoint.createExchange(message);
        try {
            LOG.debug("Processing message: {}", (Object)message);
            this.processor.process(exchange, doneSync -> {});
        }
        catch (Exception e) {
            throw new JGroupsException("Error in consumer while dispatching exchange containing message " + message, e);
        }
    }

    public Exchange createExchange(View view) {
        Exchange exchange = this.consumer.createExchange(true);
        exchange.getIn().setHeader("JGROUPS_CHANNEL_ADDRESS", this.endpoint.getResolvedChannel().getAddress());
        exchange.getIn().setBody(view);
        return exchange;
    }
}

