/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jgroups.JGroupsConstants;
import org.apache.camel.component.jgroups.JGroupsConsumer;
import org.apache.camel.component.jgroups.JGroupsProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.13.0", scheme="jgroups", title="JGroups", syntax="jgroups:clusterName", category={Category.CLUSTERING, Category.MESSAGING}, headersClass=JGroupsConstants.class)
public class JGroupsEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsEndpoint.class);
    private AtomicInteger connectCount = new AtomicInteger();
    private JChannel channel;
    private JChannel resolvedChannel;
    @UriPath
    @Metadata(required=true)
    private String clusterName;
    @UriParam
    private String channelProperties;
    @UriParam(label="consumer")
    private boolean enableViewMessages;

    public JGroupsEndpoint(String endpointUri, Component component, JChannel channel, String clusterName, String channelProperties, boolean enableViewMessages) {
        super(endpointUri, component);
        this.channel = channel;
        this.clusterName = clusterName;
        this.channelProperties = channelProperties;
        this.enableViewMessages = enableViewMessages;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new JGroupsProducer(this, this.clusterName);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        JGroupsConsumer consumer = new JGroupsConsumer(this, processor, this.clusterName);
        this.configureConsumer(consumer);
        return consumer;
    }

    public Exchange createExchange(Message message) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setHeader("JGROUPS_ORIGINAL_MESSAGE", message);
        exchange.getIn().setHeader("JGROUPS_SRC", message.getSrc());
        exchange.getIn().setHeader("JGROUPS_DEST", message.getDest());
        exchange.getIn().setBody(message.getObject());
        return exchange;
    }

    public Exchange createExchange(View view) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setBody(view);
        return exchange;
    }

    @Override
    public Exchange createExchange() {
        Exchange exchange = super.createExchange();
        exchange.getIn().setHeader("JGROUPS_CHANNEL_ADDRESS", this.resolvedChannel.getAddress());
        return exchange;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.resolvedChannel = this.resolveChannel();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.resolvedChannel != null) {
            LOG.trace("Closing JGroups Channel {}", (Object)this.getEndpointUri());
            this.resolvedChannel.close();
        }
        super.doStop();
    }

    private JChannel resolveChannel() throws Exception {
        if (this.channel != null) {
            return this.channel;
        }
        if (this.channelProperties != null && !this.channelProperties.isEmpty()) {
            return new JChannel(this.channelProperties);
        }
        return new JChannel();
    }

    public void connect() throws Exception {
        this.connectCount.incrementAndGet();
        LOG.trace("Connecting JGroups Channel {}", (Object)this.getEndpointUri());
        this.resolvedChannel.connect(this.clusterName);
    }

    public void disconnect() {
        if (this.connectCount.decrementAndGet() == 0) {
            LOG.trace("Disconnecting JGroups Channel {}", (Object)this.getEndpointUri());
            this.resolvedChannel.disconnect();
        }
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public void setChannel(JChannel channel) {
        this.channel = channel;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getChannelProperties() {
        return this.channelProperties;
    }

    public void setChannelProperties(String channelProperties) {
        this.channelProperties = channelProperties;
    }

    JChannel getResolvedChannel() {
        return this.resolvedChannel;
    }

    public boolean isEnableViewMessages() {
        return this.enableViewMessages;
    }

    public void setEnableViewMessages(boolean enableViewMessages) {
        this.enableViewMessages = enableViewMessages;
    }
}

