/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resume;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.Offset;
import org.apache.camel.resume.OffsetKey;
import org.apache.camel.resume.Resumable;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.resume.ResumeStrategyConfiguration;
import org.apache.camel.resume.ResumeStrategyConfigurationBuilder;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.spi.annotations.JdkService;

@JdkService(value="transient-resume-strategy")
public class TransientResumeStrategy
implements ResumeStrategy {
    private final ResumeAdapter resumeAdapter;

    public TransientResumeStrategy(ResumeAdapter resumeAdapter) {
        this.resumeAdapter = resumeAdapter;
    }

    @Override
    public void setAdapter(ResumeAdapter adapter) {
    }

    @Override
    public ResumeAdapter getAdapter() {
        return this.resumeAdapter;
    }

    @Override
    public <T extends ResumeAdapter> T getAdapter(Class<T> clazz) {
        return ResumeStrategy.super.getAdapter(clazz);
    }

    @Override
    public <T extends Resumable> void updateLastOffset(T offset) {
    }

    @Override
    public <T extends Resumable> void updateLastOffset(T offset, ResumeStrategy.UpdateCallBack updateCallBack) throws Exception {
    }

    @Override
    public void updateLastOffset(OffsetKey<?> offsetKey, Offset<?> offset, ResumeStrategy.UpdateCallBack updateCallBack) throws Exception {
    }

    @Override
    public void setResumeStrategyConfiguration(ResumeStrategyConfiguration resumeStrategyConfiguration) {
    }

    @Override
    public ResumeStrategyConfiguration getResumeStrategyConfiguration() {
        return TransientResumeStrategy.configurationBuilder().build();
    }

    @Override
    public void updateLastOffset(OffsetKey<?> offsetKey, Offset<?> offset) {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public static ResumeStrategyConfigurationBuilder<ResumeStrategyConfigurationBuilder, ResumeStrategyConfiguration> configurationBuilder() {
        return new ResumeStrategyConfigurationBuilder<ResumeStrategyConfigurationBuilder, ResumeStrategyConfiguration>(){

            @Override
            public ResumeStrategyConfigurationBuilder withCacheFillPolicy(Cacheable.FillPolicy cacheFillPolicy) {
                return this;
            }

            @Override
            public ResumeStrategyConfigurationBuilder withResumeCache(ResumeCache<?> resumeCache) {
                return this;
            }

            @Override
            public ResumeStrategyConfiguration build() {
                return new ResumeStrategyConfiguration(){

                    @Override
                    public ResumeCache<?> getResumeCache() {
                        return TransientResumeStrategy.createSimpleCache();
                    }

                    @Override
                    public String resumeStrategyService() {
                        return "transient-resume-strategy";
                    }
                };
            }
        };
    }

    public static ResumeCache<Object> createSimpleCache() {
        return new ResumeCache<Object>(){
            private Map<Object, Object> cache = new HashMap<Object, Object>();

            @Override
            public Object computeIfAbsent(Object key, Function<? super Object, ? super Object> mapping) {
                return this.cache.computeIfAbsent(key, mapping);
            }

            @Override
            public Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? super Object> remapping) {
                return this.cache.computeIfPresent(key, remapping);
            }

            @Override
            public boolean contains(Object key, Object entry) {
                return Objects.equals(this.cache.get(key), entry);
            }

            @Override
            public void add(Object key, Object offsetValue) {
                this.cache.put(key, offsetValue);
            }

            @Override
            public boolean isFull() {
                return false;
            }

            @Override
            public long capacity() {
                return Integer.MAX_VALUE;
            }

            @Override
            public <T> T get(Object key, Class<T> clazz) {
                Object o = this.cache.get(key);
                return clazz.cast(o);
            }

            @Override
            public Object get(Object key) {
                return this.cache.get(key);
            }

            @Override
            public void forEach(BiFunction<? super Object, ? super Object, Boolean> action) {
                for (Map.Entry<Object, Object> e : this.cache.entrySet()) {
                    if (action.apply(e.getKey(), e.getValue()).booleanValue()) continue;
                    this.cache.remove(e.getKey());
                }
            }
        };
    }
}

