/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.jibx;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class JibxDataFormat
implements DataFormat {
    private Class<?> unmarshallClass;
    private String bindingName;

    public JibxDataFormat() {
    }

    public JibxDataFormat(Class<?> unmarshallClass) {
        this.setUnmarshallClass(unmarshallClass);
    }

    public JibxDataFormat(Class<?> unmarshallClass, String bindingName) {
        this.setUnmarshallClass(unmarshallClass);
        this.setBindingName(bindingName);
    }

    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        IBindingFactory bindingFactory = this.createBindingFactory(body.getClass(), this.bindingName);
        IMarshallingContext marshallingContext = bindingFactory.createMarshallingContext();
        marshallingContext.marshalDocument(body, null, null, stream);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        ObjectHelper.notNull(this.getUnmarshallClass(), (String)"unmarshallClass");
        IBindingFactory bindingFactory = this.createBindingFactory(this.getUnmarshallClass(), this.bindingName);
        IUnmarshallingContext unmarshallingContext = bindingFactory.createUnmarshallingContext();
        return unmarshallingContext.unmarshalDocument(stream, null);
    }

    public Class<?> getUnmarshallClass() {
        return this.unmarshallClass;
    }

    public void setUnmarshallClass(Class<?> unmarshallClass) {
        this.unmarshallClass = unmarshallClass;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    private IBindingFactory createBindingFactory(Class<?> clazz, String bindingName) throws JiBXException {
        if (bindingName == null) {
            return BindingDirectory.getFactory(clazz);
        }
        return BindingDirectory.getFactory(bindingName, clazz);
    }
}

