/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator.jing;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.util.ExchangeHelper;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class JingValidator
extends DefaultProducer {
    private Schema schema;

    public JingValidator(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        Jaxp11XMLReaderCreator xmlCreator = new Jaxp11XMLReaderCreator();
        DefaultValidationErrorHandler errorHandler = new DefaultValidationErrorHandler();
        PropertyMapBuilder mapBuilder = new PropertyMapBuilder();
        mapBuilder.put(ValidateProperty.XML_READER_CREATOR, xmlCreator);
        mapBuilder.put(ValidateProperty.ERROR_HANDLER, errorHandler);
        PropertyMap propertyMap = mapBuilder.toPropertyMap();
        Validator validator = this.getSchema().createValidator(propertyMap);
        Message in = exchange.getIn();
        SAXSource saxSource = (SAXSource)in.getBody(SAXSource.class);
        if (saxSource == null) {
            Source source = (Source)exchange.getIn().getMandatoryBody(Source.class);
            saxSource = (SAXSource)ExchangeHelper.convertToMandatoryType((Exchange)exchange, SAXSource.class, (Object)source);
        }
        InputSource bodyInput = saxSource.getInputSource();
        XMLReader reader = xmlCreator.createXMLReader();
        reader.setContentHandler(validator.getContentHandler());
        reader.setDTDHandler(validator.getDTDHandler());
        reader.setErrorHandler((ErrorHandler)errorHandler);
        reader.parse(bodyInput);
        errorHandler.handleErrors(exchange, (Object)this.schema);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

