/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.AuditRestClient;
import com.atlassian.jira.rest.client.api.domain.AuditRecordInput;
import com.atlassian.jira.rest.client.api.domain.AuditRecordsData;
import com.atlassian.jira.rest.client.api.domain.input.AuditRecordSearchInput;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.AuditRecordsJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.gen.AuditRecordInputJsonGenerator;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.ws.rs.core.UriBuilder;

public class AsynchronousAuditRestClient
extends AbstractAsynchronousRestClient
implements AuditRestClient {
    private final URI baseUri;
    private final AuditRecordsJsonParser auditRecordsParser = new AuditRecordsJsonParser();

    protected AsynchronousAuditRestClient(HttpClient client, URI baseUri) {
        super(client);
        this.baseUri = baseUri;
    }

    @Override
    public Promise<AuditRecordsData> getAuditRecords(AuditRecordSearchInput input) {
        return this.getAndParse(this.createSearchPathFromInput(input == null ? new AuditRecordSearchInput(null, null, null, null, null) : input), this.auditRecordsParser);
    }

    protected UriBuilder createPathBuilder() {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri);
        uriBuilder.path("auditing/record");
        return uriBuilder;
    }

    @Override
    public void addAuditRecord(@Nonnull AuditRecordInput record) {
        this.post(this.createPathBuilder().build(new Object[0]), record, new AuditRecordInputJsonGenerator()).claim();
    }

    private URI createSearchPathFromInput(AuditRecordSearchInput input) {
        UriBuilder uriBuilder = this.createPathBuilder();
        if (input.getOffset() != null) {
            uriBuilder.queryParam("offset", input.getOffset());
        }
        if (input.getLimit() != null) {
            uriBuilder.queryParam("limit", input.getLimit());
        }
        if (input.getTextFilter() != null) {
            uriBuilder.queryParam("filter", input.getTextFilter());
        }
        if (input.getFrom() != null) {
            String fromIsoString = JsonParseUtil.JIRA_DATE_TIME_FORMATTER.print(input.getFrom());
            uriBuilder.queryParam("from", fromIsoString);
        }
        if (input.getTo() != null) {
            String toIsoString = JsonParseUtil.JIRA_DATE_TIME_FORMATTER.print(input.getTo());
            uriBuilder.queryParam("to", toIsoString);
        }
        return uriBuilder.build(new Object[0]);
    }
}

