/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json.gen;

import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.atlassian.jira.rest.client.api.domain.Visibility;
import com.atlassian.jira.rest.client.api.domain.input.WorklogInput;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.gen.BasicUserJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.VisibilityJsonGenerator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.format.DateTimeFormatter;

public class WorklogInputJsonGenerator
implements JsonGenerator<WorklogInput> {
    private final JsonGenerator<Visibility> visibilityGenerator = new VisibilityJsonGenerator();
    private final JsonGenerator<BasicUser> basicUserJsonGenerator = new BasicUserJsonGenerator();
    private final DateTimeFormatter dateTimeFormatter;

    public WorklogInputJsonGenerator() {
        this(JsonParseUtil.JIRA_DATE_TIME_FORMATTER);
    }

    public WorklogInputJsonGenerator(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public JSONObject generate(WorklogInput worklogInput) throws JSONException {
        JSONObject res = new JSONObject().put("self", worklogInput.getSelf()).put("comment", worklogInput.getComment()).put("started", this.dateTimeFormatter.print(worklogInput.getStartDate())).put("timeSpent", worklogInput.getMinutesSpent() + "m");
        this.putGeneratedIfNotNull("visibility", worklogInput.getVisibility(), res, this.visibilityGenerator);
        this.putGeneratedIfNotNull("author", worklogInput.getAuthor(), res, this.basicUserJsonGenerator);
        this.putGeneratedIfNotNull("updateAuthor", worklogInput.getUpdateAuthor(), res, this.basicUserJsonGenerator);
        return res;
    }

    private <K> JSONObject putGeneratedIfNotNull(String key, K value, JSONObject dest, JsonGenerator<K> generator) throws JSONException {
        if (value != null) {
            dest.put(key, generator.generate(value));
        }
        return dest;
    }
}

