/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import java.net.URI;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.OptionsGroup;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.jira.JiraConfiguration;
import org.apache.camel.component.jira.oauth.JiraOAuthAuthenticationHandler;
import org.apache.camel.component.jira.oauth.OAuthAsynchronousJiraRestClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraVerifierExtension
extends DefaultComponentVerifierExtension {
    private static final Logger LOG = LoggerFactory.getLogger(JiraVerifierExtension.class);

    public JiraVerifierExtension() {
        super("jira");
    }

    @Override
    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption("jiraUrl", parameters)).errors(ResultErrorHelper.requiresAny(parameters, OptionsGroup.withName("basic_authentication").options("username", "password", "!requestToken", "!privateKey", "!consumerKey", "!verificationCode", "!accessToken"), OptionsGroup.withName("oauth_authentication").options("requestToken", "privateKey", "consumerKey", "verificationCode", "accessToken", "!username", "!password")));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    @Override
    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.CONNECTIVITY);
        try {
            JiraConfiguration conf = this.setProperties(new JiraConfiguration(), parameters);
            OAuthAsynchronousJiraRestClientFactory factory = new OAuthAsynchronousJiraRestClientFactory();
            URI jiraServerUri = URI.create(conf.getJiraUrl());
            try (JiraRestClient client = JiraVerifierExtension.newJiraRestClient(conf, factory, jiraServerUri);){
                ServerInfo serverInfo = client.getMetadataClient().getServerInfo().claim();
                LOG.info("Verify connectivity to jira server OK: {}", (Object)serverInfo);
            }
        }
        catch (RestClientException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, e.getMessage()).detail("jira_exception_message", (Object)e.getMessage()).detail("jira_status_code", e.getStatusCode()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)e.getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            builder.error(errorBuilder.build());
        }
        catch (Exception e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, e.getMessage()).detail("jira_exception_message", (Object)e.getMessage()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)e.getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            builder.error(errorBuilder.build());
        }
        return builder.build();
    }

    private static JiraRestClient newJiraRestClient(JiraConfiguration conf, OAuthAsynchronousJiraRestClientFactory factory, URI jiraServerUri) {
        if (conf.getUsername() != null) {
            return factory.createWithBasicHttpAuthentication(jiraServerUri, conf.getUsername(), conf.getPassword());
        }
        JiraOAuthAuthenticationHandler oAuthHandler = new JiraOAuthAuthenticationHandler(conf.getConsumerKey(), conf.getVerificationCode(), conf.getPrivateKey(), conf.getAccessToken(), conf.getJiraUrl());
        return factory.create(jiraServerUri, oAuthHandler);
    }
}

