/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJiraConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJiraConsumer.class);
    private final JiraEndpoint endpoint;

    public AbstractJiraConsumer(JiraEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.setDelay(endpoint.getDelay());
    }

    @Override
    public JiraEndpoint getEndpoint() {
        return (JiraEndpoint)super.getEndpoint();
    }

    protected abstract int doPoll() throws Exception;

    @Override
    public int poll() throws Exception {
        try {
            return this.doPoll();
        }
        catch (Exception e) {
            int code;
            RestClientException rcr = ObjectHelper.getException(RestClientException.class, e);
            if (rcr != null && rcr.getStatusCode().isPresent() && (code = rcr.getStatusCode().get().intValue()) >= 400) {
                LOG.warn("RestClientException error code: {} caused by {}. Will re-connect on next poll.", (Object)code, (Object)rcr.getMessage());
                this.getEndpoint().disconnect();
            }
            throw e;
        }
    }

    protected List<Issue> getIssues() {
        return this.getIssues(this.endpoint.getJql(), 0, 50, this.endpoint.getMaxResults());
    }

    protected List<Issue> getIssues(String jql, int start, int maxPerQuery, int maxResults) {
        LOG.debug("Start indexing current JIRA issues...");
        if (maxResults < maxPerQuery) {
            maxPerQuery = maxResults;
        }
        LinkedHashSet<Issue> issues = new LinkedHashSet<Issue>();
        while (true) {
            SearchRestClient searchRestClient = this.endpoint.getClient().getSearchClient();
            SearchResult searchResult = searchRestClient.searchJql(jql, maxPerQuery, start, null).claim();
            for (Issue issue : searchResult.getIssues()) {
                issues.add(issue);
            }
            if (maxPerQuery >= searchResult.getTotal() || start >= searchResult.getTotal() || maxResults > 0 && issues.size() >= maxResults) break;
            start += maxPerQuery;
        }
        LOG.debug("End indexing current JIRA issues. {} issues indexed.", (Object)issues.size());
        return new ArrayList<Issue>(issues);
    }

    protected JiraRestClient client() {
        return this.endpoint.getClient();
    }
}

