/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.oauth;

import com.atlassian.httpclient.apache.httpcomponents.DefaultRequest;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import java.net.URI;
import java.util.regex.Pattern;

public abstract class OAuthHttpClientDecorator
implements DisposableHttpClient {
    private final HttpClient httpClient;
    private final AuthenticationHandler authenticationHandler;
    private URI uri;

    public OAuthHttpClientDecorator(HttpClient httpClient, AuthenticationHandler authenticationHandler) {
        this.httpClient = httpClient;
        this.authenticationHandler = authenticationHandler;
    }

    @Override
    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpClient.flushCacheByUriPattern(urlPattern);
    }

    @Override
    public Request.Builder newRequest() {
        return new OAuthAuthenticatedRequestBuilder();
    }

    @Override
    public Request.Builder newRequest(URI uri) {
        OAuthAuthenticatedRequestBuilder builder = new OAuthAuthenticatedRequestBuilder();
        builder.setUri(uri);
        this.uri = uri;
        return builder;
    }

    @Override
    public Request.Builder newRequest(URI uri, String contentType, String entity) {
        OAuthAuthenticatedRequestBuilder builder = new OAuthAuthenticatedRequestBuilder();
        this.uri = uri;
        builder.setUri(uri);
        builder.setContentType(contentType);
        builder.setEntity(entity);
        return builder;
    }

    @Override
    public Request.Builder newRequest(String uri) {
        OAuthAuthenticatedRequestBuilder builder = new OAuthAuthenticatedRequestBuilder();
        this.uri = URI.create(uri);
        builder.setUri(this.uri);
        return builder;
    }

    @Override
    public Request.Builder newRequest(String uri, String contentType, String entity) {
        OAuthAuthenticatedRequestBuilder builder = new OAuthAuthenticatedRequestBuilder();
        this.uri = URI.create(uri);
        builder.setUri(this.uri);
        builder.setContentType(contentType);
        builder.setEntity(entity);
        return builder;
    }

    @Override
    public <A> ResponseTransformation.Builder<A> transformation() {
        return this.httpClient.transformation();
    }

    @Override
    public ResponsePromise execute(Request request) {
        return this.httpClient.execute(request);
    }

    public class OAuthAuthenticatedRequestBuilder
    extends DefaultRequest.DefaultRequestBuilder {
        Request.Method method;

        OAuthAuthenticatedRequestBuilder() {
            super(OAuthHttpClientDecorator.this.httpClient);
        }

        @Override
        public ResponsePromise execute(Request.Method method) {
            if (OAuthHttpClientDecorator.this.authenticationHandler != null) {
                this.setMethod(method);
                this.method = method;
                OAuthHttpClientDecorator.this.authenticationHandler.configure(this);
            }
            return super.execute(method);
        }

        public URI getUri() {
            return OAuthHttpClientDecorator.this.uri;
        }
    }
}

