/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import java.io.File;
import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachFileProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(AttachFileProducer.class);

    public AttachFileProducer(JiraEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws InvalidPayloadException {
        String issueKey = exchange.getIn().getHeader("IssueKey", String.class);
        if (issueKey == null) {
            throw new IllegalArgumentException("Missing exchange input header named 'IssueKey', it should specify the issue key to attach a file.");
        }
        File file = exchange.getIn().getMandatoryBody(File.class);
        JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
        IssueRestClient issueClient = client.getIssueClient();
        Issue issue = issueClient.getIssue(issueKey).claim();
        URI attachmentsUri = issue.getAttachmentsUri();
        issueClient.addAttachments(attachmentsUri, file);
    }
}

