/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;

public class UseLatestAggregationStrategy
implements AggregationStrategy {
    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            return newExchange;
        }
        Exchange answer = null;
        this.propagateException(oldExchange, newExchange);
        if (newExchange.getException() != null) {
            answer = newExchange;
        }
        if (answer == null) {
            answer = this.propagateFailure(oldExchange, newExchange);
        }
        return answer;
    }

    protected void propagateException(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return;
        }
        if (newExchange.getException() == null) {
            newExchange.setException(oldExchange.getException());
            newExchange.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, oldExchange.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT));
        }
    }

    protected Exchange propagateFailure(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return newExchange;
        }
        ExtendedExchange oee = (ExtendedExchange)oldExchange;
        if (oee.isFailed() || oee.isRollbackOnly() || oee.isRollbackOnlyLast() || oee.isErrorHandlerHandledSet() && oee.isErrorHandlerHandled()) {
            return oldExchange;
        }
        return newExchange;
    }

    public String toString() {
        return "UseLatestAggregationStrategy";
    }
}

