/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.util.Map;
import javax.json.JsonMergePatch;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.johnzon.core.DiffBase;
import org.apache.johnzon.core.JsonMergePatchImpl;
import org.apache.johnzon.core.JsonObjectBuilderImpl;

class JsonMergePatchDiff
extends DiffBase {
    private final JsonValue source;
    private final JsonValue target;

    public JsonMergePatchDiff(JsonValue source, JsonValue target) {
        this.source = source;
        this.target = target;
    }

    public JsonMergePatch calculateDiff() {
        return new JsonMergePatchImpl(this.diff(this.source, this.target));
    }

    private JsonValue diff(JsonValue source, JsonValue target) {
        JsonObjectBuilderImpl builder = new JsonObjectBuilderImpl();
        if (this.isJsonObject(source) && this.isJsonObject(target)) {
            String attributeName;
            JsonObject srcObj = source.asJsonObject();
            JsonObject targetObj = target.asJsonObject();
            for (Map.Entry sourceEntry : srcObj.entrySet()) {
                attributeName = (String)sourceEntry.getKey();
                if (targetObj.containsKey(attributeName)) {
                    JsonValue attribDiff = this.diff((JsonValue)sourceEntry.getValue(), (JsonValue)targetObj.get(attributeName));
                    if (JsonValue.EMPTY_JSON_OBJECT.equals(attribDiff)) continue;
                    builder.add(attributeName, attribDiff);
                    continue;
                }
                builder.add(attributeName, JsonValue.NULL);
            }
            for (Map.Entry targetEntry : targetObj.entrySet()) {
                attributeName = (String)targetEntry.getKey();
                if (srcObj.containsKey(attributeName)) continue;
                builder.add(attributeName, (JsonValue)targetEntry.getValue());
            }
            return builder.build();
        }
        if (source.equals(target)) {
            return JsonValue.EMPTY_JSON_OBJECT;
        }
        return target;
    }
}

