/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonMergePatch;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonPointer;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.core.JsonBuilderFactoryImpl;
import org.apache.johnzon.core.JsonDoubleImpl;
import org.apache.johnzon.core.JsonGeneratorFactoryImpl;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonMergePatchDiff;
import org.apache.johnzon.core.JsonMergePatchImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonParserFactoryImpl;
import org.apache.johnzon.core.JsonPatchBuilderImpl;
import org.apache.johnzon.core.JsonPatchDiff;
import org.apache.johnzon.core.JsonPointerImpl;
import org.apache.johnzon.core.JsonReaderFactoryImpl;
import org.apache.johnzon.core.JsonStringImpl;
import org.apache.johnzon.core.JsonWriterFactoryImpl;

public class JsonProviderImpl
extends JsonProvider
implements Serializable {
    private static final JsonProvider DELEGATE = new JsonProviderDelegate();

    @Override
    public JsonParser createParser(Reader reader) {
        return DELEGATE.createParser(reader);
    }

    @Override
    public JsonParser createParser(InputStream inputStream) {
        return DELEGATE.createParser(inputStream);
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> stringMap) {
        return DELEGATE.createParserFactory(stringMap);
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return DELEGATE.createGenerator(writer);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream) {
        return DELEGATE.createGenerator(outputStream);
    }

    @Override
    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> stringMap) {
        return DELEGATE.createGeneratorFactory(stringMap);
    }

    @Override
    public JsonReader createReader(Reader reader) {
        return DELEGATE.createReader(reader);
    }

    @Override
    public JsonReader createReader(InputStream inputStream) {
        return DELEGATE.createReader(inputStream);
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return DELEGATE.createWriter(writer);
    }

    @Override
    public JsonWriter createWriter(OutputStream outputStream) {
        return DELEGATE.createWriter(outputStream);
    }

    @Override
    public JsonWriterFactory createWriterFactory(Map<String, ?> stringMap) {
        return DELEGATE.createWriterFactory(stringMap);
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> stringMap) {
        return DELEGATE.createReaderFactory(stringMap);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return DELEGATE.createObjectBuilder();
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return DELEGATE.createArrayBuilder();
    }

    @Override
    public JsonBuilderFactory createBuilderFactory(Map<String, ?> stringMap) {
        return DELEGATE.createBuilderFactory(stringMap);
    }

    @Override
    public JsonPatchBuilder createPatchBuilder() {
        return DELEGATE.createPatchBuilder();
    }

    @Override
    public JsonPatchBuilder createPatchBuilder(JsonArray initialData) {
        return DELEGATE.createPatchBuilder(initialData);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(JsonObject jsonObject) {
        return DELEGATE.createObjectBuilder(jsonObject);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(Map<String, Object> map) {
        return DELEGATE.createObjectBuilder(map);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(JsonArray initialData) {
        return DELEGATE.createArrayBuilder(initialData);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(Collection<?> initialData) {
        return DELEGATE.createArrayBuilder(initialData);
    }

    @Override
    public JsonPointer createPointer(String path) {
        return DELEGATE.createPointer(path);
    }

    @Override
    public JsonString createValue(String value) {
        return DELEGATE.createValue(value);
    }

    @Override
    public JsonNumber createValue(int value) {
        return DELEGATE.createValue(value);
    }

    @Override
    public JsonNumber createValue(long value) {
        return DELEGATE.createValue(value);
    }

    @Override
    public JsonNumber createValue(double value) {
        return DELEGATE.createValue(value);
    }

    @Override
    public JsonNumber createValue(BigDecimal value) {
        return DELEGATE.createValue(value);
    }

    @Override
    public JsonNumber createValue(BigInteger value) {
        return DELEGATE.createValue(value);
    }

    @Override
    public JsonPatch createPatch(JsonArray array) {
        return DELEGATE.createPatch(array);
    }

    @Override
    public JsonPatch createDiff(JsonStructure source, JsonStructure target) {
        return DELEGATE.createDiff(source, target);
    }

    @Override
    public JsonMergePatch createMergePatch(JsonValue patch) {
        return DELEGATE.createMergePatch(patch);
    }

    @Override
    public JsonMergePatch createMergeDiff(JsonValue source, JsonValue target) {
        return DELEGATE.createMergeDiff(source, target);
    }

    static class JsonProviderDelegate
    extends JsonProvider {
        private final JsonReaderFactory readerFactory = new JsonReaderFactoryImpl(null);
        private final JsonParserFactory parserFactory = new JsonParserFactoryImpl(null);
        private final JsonGeneratorFactory generatorFactory = new JsonGeneratorFactoryImpl(null);
        private final JsonWriterFactory writerFactory = new JsonWriterFactoryImpl(null);
        private final JsonBuilderFactoryImpl builderFactory = new JsonBuilderFactoryImpl(null);

        JsonProviderDelegate() {
        }

        @Override
        public JsonParser createParser(InputStream in) {
            return this.parserFactory.createParser(in);
        }

        @Override
        public JsonParser createParser(Reader reader) {
            return this.parserFactory.createParser(reader);
        }

        @Override
        public JsonReader createReader(InputStream in) {
            return this.readerFactory.createReader(in);
        }

        @Override
        public JsonReader createReader(Reader reader) {
            return this.readerFactory.createReader(reader);
        }

        @Override
        public JsonParserFactory createParserFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.parserFactory : new JsonParserFactoryImpl(config);
        }

        @Override
        public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.readerFactory : new JsonReaderFactoryImpl(config);
        }

        @Override
        public JsonGenerator createGenerator(Writer writer) {
            return this.generatorFactory.createGenerator(writer);
        }

        @Override
        public JsonGenerator createGenerator(OutputStream out) {
            return this.generatorFactory.createGenerator(out);
        }

        @Override
        public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.generatorFactory : new JsonGeneratorFactoryImpl(config);
        }

        @Override
        public JsonWriter createWriter(Writer writer) {
            return this.writerFactory.createWriter(writer);
        }

        @Override
        public JsonWriter createWriter(OutputStream out) {
            return this.writerFactory.createWriter(out);
        }

        @Override
        public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.writerFactory : new JsonWriterFactoryImpl(config);
        }

        @Override
        public JsonObjectBuilder createObjectBuilder() {
            return this.builderFactory.createObjectBuilder();
        }

        @Override
        public JsonObjectBuilder createObjectBuilder(JsonObject jsonObject) {
            return this.builderFactory.createObjectBuilder(jsonObject);
        }

        @Override
        public JsonObjectBuilder createObjectBuilder(Map<String, Object> initialValues) {
            return this.builderFactory.createObjectBuilder(initialValues);
        }

        @Override
        public JsonArrayBuilder createArrayBuilder() {
            return this.builderFactory.createArrayBuilder();
        }

        @Override
        public JsonArrayBuilder createArrayBuilder(JsonArray initialData) {
            return this.builderFactory.createArrayBuilder(initialData);
        }

        @Override
        public JsonArrayBuilder createArrayBuilder(Collection<?> initialData) {
            return this.builderFactory.createArrayBuilder(initialData);
        }

        @Override
        public JsonString createValue(String value) {
            return new JsonStringImpl(value);
        }

        @Override
        public JsonNumber createValue(int value) {
            return new JsonLongImpl(value);
        }

        @Override
        public JsonNumber createValue(long value) {
            return new JsonLongImpl(value);
        }

        @Override
        public JsonNumber createValue(double value) {
            return new JsonDoubleImpl(value);
        }

        @Override
        public JsonNumber createValue(BigDecimal value) {
            return new JsonNumberImpl(value);
        }

        @Override
        public JsonNumber createValue(BigInteger value) {
            return new JsonLongImpl(value.longValue());
        }

        @Override
        public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.builderFactory : new JsonBuilderFactoryImpl(config);
        }

        @Override
        public JsonPatchBuilder createPatchBuilder() {
            return new JsonPatchBuilderImpl(this);
        }

        @Override
        public JsonPatchBuilder createPatchBuilder(JsonArray initialData) {
            return new JsonPatchBuilderImpl(this, initialData);
        }

        @Override
        public JsonPointer createPointer(String path) {
            return new JsonPointerImpl(this, path);
        }

        @Override
        public JsonPatch createPatch(JsonArray array) {
            return this.createPatchBuilder(array).build();
        }

        @Override
        public JsonPatch createDiff(JsonStructure source, JsonStructure target) {
            return new JsonPatchDiff(this, source, target).calculateDiff();
        }

        @Override
        public JsonMergePatch createMergePatch(JsonValue patch) {
            return new JsonMergePatchImpl(patch);
        }

        @Override
        public JsonMergePatch createMergeDiff(JsonValue source, JsonValue target) {
            return new JsonMergePatchDiff(source, target).calculateDiff();
        }
    }
}

