/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.ExceptionMessages;
import org.apache.johnzon.mapper.FactoryCreateException;
import org.apache.johnzon.mapper.MapperConfig;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.MappingParser;
import org.apache.johnzon.mapper.Mappings;
import org.apache.johnzon.mapper.MissingFactoryException;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.SetterMappingException;
import org.apache.johnzon.mapper.TypeAwareAdapter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.converter.CharacterConverter;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.internal.JsonPointerTracker;
import org.apache.johnzon.mapper.number.Validator;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;

public class MappingParserImpl
implements MappingParser {
    private static final JohnzonParameterizedType ANY_LIST = new JohnzonParameterizedType((Type)((Object)List.class), new Type[]{Object.class});
    private static final CharacterConverter CHARACTER_CONVERTER = new CharacterConverter();
    protected final ConcurrentMap<Class<?>, Method> valueOfs = new ConcurrentHashMap();
    private final MapperConfig config;
    private final Mappings mappings;
    private final JsonReader jsonReader;
    private Map<String, Object> jsonPointers;

    public MappingParserImpl(MapperConfig config, Mappings mappings, JsonReader jsonReader, Map<String, Object> jsonPointers) {
        this.config = config;
        this.mappings = mappings;
        this.jsonReader = jsonReader;
    }

    @Override
    public <T> T readObject(Type targetType) {
        try {
            return this.readObject(this.jsonReader.readValue(), targetType);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return this.readObject(this.jsonReader.read(), targetType);
        }
    }

    @Override
    public <T> T readObject(JsonValue jsonValue, Type targetType) {
        return this.readObject(jsonValue, targetType, targetType instanceof Class || targetType instanceof ParameterizedType, null);
    }

    public <T> T readObject(JsonValue jsonValue, Type targetType, boolean applyObjectConverter, Collection<Class<?>> skippedConverters) {
        JsonValue.ValueType valueType;
        JsonValue.ValueType valueType2 = valueType = jsonValue != null ? jsonValue.getValueType() : null;
        if (JsonStructure.class == targetType || JsonObject.class == targetType || JsonValue.class == targetType) {
            return (T)jsonValue;
        }
        if (JsonObject.class.isInstance(jsonValue)) {
            return (T)this.buildObject(targetType, (JsonObject)JsonObject.class.cast(jsonValue), applyObjectConverter, null, skippedConverters);
        }
        if (JsonString.class.isInstance(jsonValue)) {
            if (targetType == String.class || targetType == Object.class) {
                return (T)((JsonString)JsonString.class.cast(jsonValue)).getString();
            }
            if (targetType == Character.class || targetType == Character.TYPE) {
                CharSequence string = ((JsonString)JsonString.class.cast(jsonValue)).getChars();
                if (string.length() == 1) {
                    return (T)Character.valueOf(string.charAt(0));
                }
                throw new IllegalArgumentException("Invalid Character binding");
            }
            Mappings.ClassMapping classMapping = this.mappings.getClassMapping(targetType);
            if (classMapping != null && classMapping.adapter != null) {
                return (T)classMapping.adapter.to(((JsonString)JsonString.class.cast(jsonValue)).getString());
            }
            Adapter adapter = this.findAdapter(targetType);
            if (adapter != null && TypeAwareAdapter.class.isInstance(adapter)) {
                TypeAwareAdapter typeAwareAdapter = (TypeAwareAdapter)TypeAwareAdapter.class.cast(adapter);
                if (typeAwareAdapter.getTo() == String.class) {
                    return (T)adapter.to(((JsonString)JsonString.class.cast(jsonValue)).getString());
                }
                if (typeAwareAdapter.getTo() == JsonString.class) {
                    return (T)adapter.to(JsonString.class.cast(jsonValue));
                }
                if (typeAwareAdapter.getTo() == CharSequence.class) {
                    return (T)adapter.to(((JsonString)JsonString.class.cast(jsonValue)).getChars());
                }
            }
        }
        if (JsonNumber.class.isInstance(jsonValue)) {
            JsonNumber number = (JsonNumber)JsonNumber.class.cast(jsonValue);
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return (T)Integer.valueOf(number.intValue());
            }
            if (targetType == Long.TYPE || targetType == Long.class) {
                return (T)Long.valueOf(number.longValue());
            }
            if (targetType == Double.TYPE || targetType == Double.class || targetType == Object.class) {
                return (T)Double.valueOf(number.doubleValue());
            }
            if (targetType == Float.TYPE || targetType == Float.class) {
                return (T)Float.valueOf((float)number.doubleValue());
            }
            if (targetType == Byte.TYPE || targetType == Byte.class) {
                int intValue = number.intValue();
                Validator.validateByte(intValue);
                return (T)Byte.valueOf((byte)intValue);
            }
            if (targetType == Short.TYPE || targetType == Short.class) {
                return (T)Short.valueOf((short)number.intValue());
            }
            if (targetType == BigDecimal.class || Number.class == targetType) {
                return (T)number.bigDecimalValue();
            }
            if (targetType == BigInteger.class) {
                return (T)number.bigIntegerValue();
            }
        }
        if (JsonArray.class.isInstance(jsonValue)) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            if (Class.class.isInstance(targetType)) {
                Class asClass = (Class)targetType;
                if (asClass.isArray()) {
                    Class<?> componentType = asClass.getComponentType();
                    return (T)this.buildArrayWithComponentType(jsonArray, componentType, this.config.findAdapter(componentType), this.isDedup() ? JsonPointerTracker.ROOT : null, (Type)((Object)Object.class));
                }
                if (Collection.class.isAssignableFrom(asClass)) {
                    return this.readObject(jsonValue, new JohnzonParameterizedType(asClass, new Type[]{Object.class}), applyObjectConverter, skippedConverters);
                }
            }
            if (ParameterizedType.class.isInstance(targetType)) {
                ParameterizedType pt = (ParameterizedType)targetType;
                Mappings.CollectionMapping mapping = this.mappings.findCollectionMapping(pt, (Type)((Object)Object.class));
                if (mapping == null) {
                    throw new UnsupportedOperationException("type " + targetType + " not supported");
                }
                Type arg = pt.getActualTypeArguments()[0];
                return (T)this.mapCollection(mapping, jsonArray, Class.class.isInstance(arg) ? this.config.findAdapter((Type)Class.class.cast(arg)) : null, null, this.isDedup() ? JsonPointerTracker.ROOT : null, (Type)((Object)Object.class));
            }
            if (Object.class == targetType) {
                return (T)new ArrayList<Object>(Arrays.asList((Object[])Object[].class.cast(this.buildArrayWithComponentType(jsonArray, Object.class, null, this.isDedup() ? JsonPointerTracker.ROOT : null, (Type)((Object)Object.class)))));
            }
        }
        if (JsonValue.ValueType.NULL == valueType) {
            return null;
        }
        if (JsonValue.ValueType.TRUE == valueType && (Boolean.class == targetType || Boolean.TYPE == targetType || Object.class == targetType)) {
            return (T)Boolean.TRUE;
        }
        if (JsonValue.ValueType.FALSE == valueType && (Boolean.class == targetType || Boolean.TYPE == targetType || Object.class == targetType)) {
            return (T)Boolean.FALSE;
        }
        String snippet = this.config.getSnippet().of(jsonValue);
        String description = ExceptionMessages.description(valueType);
        throw new IllegalArgumentException(targetType + " does not support " + description + ": " + snippet);
    }

    private boolean isDedup() {
        return this.jsonPointers != Collections.emptyMap();
    }

    private Object buildObject(Type inType, JsonObject object, boolean applyObjectConverter, JsonPointerTracker jsonPointer, Collection<Class<?>> skippedConverters) {
        Object t;
        Mappings.ClassMapping classMapping;
        Class clazz;
        Type type;
        Type type2 = type = inType == Object.class ? new JohnzonParameterizedType((Type)((Object)Map.class), new Type[]{String.class, Object.class}) : inType;
        if (applyObjectConverter && !(type instanceof ParameterizedType)) {
            ObjectConverter.Reader objectConverter;
            if (!(type instanceof Class)) {
                throw new MapperException("ObjectConverters are only supported for Classes not Types");
            }
            clazz = (Class)type;
            if (!(skippedConverters != null && skippedConverters.contains(clazz) || (objectConverter = this.config.findObjectConverterReader(clazz)) == null)) {
                ArrayList skipped = skippedConverters == null ? new ArrayList() : skippedConverters;
                skipped.add(clazz);
                return objectConverter.fromJson(object, type, new SuppressConversionMappingParser(this, object, skipped));
            }
        }
        if (this.config.getDeserializationPredicate() != null && Class.class.isInstance(inType)) {
            clazz = (Class)Class.class.cast(inType);
            if (this.config.getDeserializationPredicate().test(clazz) && object.containsKey(this.config.getDiscriminator())) {
                String discriminator = object.getString(this.config.getDiscriminator());
                Class<?> nestedType = this.config.getTypeLoader().apply(discriminator);
                if (nestedType != null && nestedType != inType) {
                    return this.buildObject(nestedType, object, applyObjectConverter, jsonPointer, skippedConverters);
                }
            }
        }
        if ((classMapping = this.mappings.findOrCreateClassMapping(type)) == null) {
            if (ParameterizedType.class.isInstance(type)) {
                ParameterizedType aType = (ParameterizedType)ParameterizedType.class.cast(type);
                Type[] fieldArgTypes = aType.getActualTypeArguments();
                if (fieldArgTypes.length >= 2) {
                    AbstractMap map;
                    Class clazz2 = (Class)Class.class.cast(aType.getRawType());
                    if (SortedMap.class.isAssignableFrom(clazz2) || NavigableMap.class == clazz2 || TreeMap.class == clazz2) {
                        map = this.config.getAttributeOrder() == null ? new TreeMap() : new TreeMap(this.config.getAttributeOrder());
                    } else if (ConcurrentMap.class.isAssignableFrom(clazz2)) {
                        map = new ConcurrentHashMap(object.size());
                    } else if (EnumMap.class.isAssignableFrom(clazz2)) {
                        if (!this.config.isSupportEnumContainerDeserialization()) {
                            throw new MapperException("JSON-B forbids EnumMap deserialization, set supportEnumMapDeserialization=true to disable that arbitrary limitation");
                        }
                        map = new EnumMap((Class)Class.class.cast(fieldArgTypes[0]));
                    } else {
                        map = Map.class.isAssignableFrom(clazz2) ? new LinkedHashMap(object.size()) : null;
                    }
                    if (map != null) {
                        Object keyType = fieldArgTypes[0];
                        boolean any = fieldArgTypes.length < 2 || fieldArgTypes[1] == Object.class;
                        for (Map.Entry value : object.entrySet()) {
                            JsonValue jsonValue = (JsonValue)value.getValue();
                            if (JsonNumber.class.isInstance(jsonValue) && any) {
                                map.put(value.getKey(), this.config.isUseBigDecimalForObjectNumbers() ? ((JsonNumber)JsonNumber.class.cast(jsonValue)).bigDecimalValue() : this.toNumberValue((JsonNumber)JsonNumber.class.cast(jsonValue)));
                                continue;
                            }
                            if (JsonString.class.isInstance(jsonValue) && any) {
                                map.put(value.getKey(), ((JsonString)JsonString.class.cast(jsonValue)).getString());
                                continue;
                            }
                            map.put(this.convertTo((Type)keyType, (String)value.getKey()), this.toObject(null, jsonValue, (Type)fieldArgTypes[1], null, jsonPointer, (Type)((Object)Object.class)));
                        }
                        return map;
                    }
                }
            } else if (Map.class == type || HashMap.class == type || LinkedHashMap.class == type) {
                LinkedHashMap map = new LinkedHashMap();
                for (Map.Entry entry : object.entrySet()) {
                    map.put(entry.getKey(), this.toObject(null, (JsonValue)entry.getValue(), (Type)((Object)Object.class), null, jsonPointer, (Type)((Object)Object.class)));
                }
                return map;
            }
        }
        if (classMapping == null) {
            String snippet = this.config.getSnippet().of(object);
            String description = ExceptionMessages.description(object);
            throw new MapperException("Unable to map " + description + " to " + type + ": " + snippet);
        }
        if (applyObjectConverter && classMapping.reader != null && (skippedConverters == null || !skippedConverters.contains(type))) {
            ArrayList skipped;
            ArrayList arrayList = skipped = skippedConverters == null ? new ArrayList() : skippedConverters;
            if (Class.class.isInstance(type)) {
                skipped.add((Class<?>)Class.class.cast(type));
            }
            return classMapping.reader.fromJson(object, type, new SuppressConversionMappingParser(this, object, skipped));
        }
        if (classMapping.factory == null) {
            throw new MissingFactoryException(classMapping.clazz, object, this.config.getSnippet().of(object));
        }
        if (this.config.isFailOnUnknown() && !classMapping.setters.keySet().containsAll(object.keySet())) {
            throw new MapperException("(fail on unknown properties): " + object.keySet().stream().filter(it -> !classMapping.setters.containsKey(it)).collect(Collectors.joining(", ", "[", "]")));
        }
        try {
            t = classMapping.factory.getParameterTypes() == null || classMapping.factory.getParameterTypes().length == 0 ? classMapping.factory.create(null) : classMapping.factory.create(this.createParameters(classMapping, object, jsonPointer, e -> {
                if (FactoryCreateException.class.isInstance(e)) {
                    throw (FactoryCreateException)FactoryCreateException.class.cast(e);
                }
                throw new FactoryCreateException(type, object, this.config.getSnippet().of(object), (Exception)e);
            }));
        }
        catch (FactoryCreateException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new FactoryCreateException(type, object, this.config.getSnippet().of(object), e3);
        }
        if (this.jsonPointers == null) {
            if (classMapping.deduplicateObjects || this.config.isDeduplicateObjects()) {
                this.jsonPointers = new HashMap<String, Object>();
                this.jsonPointers.put(jsonPointer == null ? "/" : jsonPointer.toString(), t);
            } else {
                this.jsonPointers = Collections.emptyMap();
            }
        } else if (this.isDedup()) {
            this.jsonPointers.put(jsonPointer == null ? "/" : jsonPointer.toString(), t);
        }
        for (Map.Entry entry : object.entrySet()) {
            Mappings.Setter value = classMapping.setters.get(entry.getKey());
            if (value == null) continue;
            JsonValue jsonValue = (JsonValue)entry.getValue();
            JsonValue.ValueType valueType = jsonValue != null ? jsonValue.getValueType() : null;
            try {
                Object convertedValue;
                Mappings.Getter getter;
                if (JsonValue.class == value.paramType) {
                    value.writer.write(t, jsonValue);
                    continue;
                }
                if (jsonValue == null) continue;
                AccessMode.Writer setterMethod = value.writer;
                if (JsonValue.ValueType.NULL == valueType) {
                    setterMethod.write(t, null);
                    continue;
                }
                Object existingInstance = null;
                if (this.config.isReadAttributeBeforeWrite() && (getter = classMapping.getters.get(entry.getKey())) != null) {
                    try {
                        existingInstance = getter.reader.read(t);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if ((convertedValue = this.toValue(existingInstance, jsonValue, value.converter, value.itemConverter, value.paramType, value.objectConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, (String)entry.getKey()) : null, inType, e -> {
                    if (SetterMappingException.class.isInstance(e)) {
                        throw (SetterMappingException)SetterMappingException.class.cast(e);
                    }
                    String snippet = this.config.getSnippet().of(jsonValue);
                    throw new SetterMappingException(classMapping.clazz, (String)jsonEntry.getKey(), value.writer.getType(), valueType, snippet, (Exception)e);
                })) == null) continue;
                setterMethod.write(t, convertedValue);
            }
            catch (SetterMappingException alreadyHandled) {
                throw alreadyHandled;
            }
            catch (Exception e4) {
                String snippet = jsonValue == null ? "null" : this.config.getSnippet().of(jsonValue);
                throw new SetterMappingException(classMapping.clazz, (String)entry.getKey(), value.writer.getType(), valueType, snippet, e4);
            }
        }
        if (classMapping.anySetter != null) {
            for (Map.Entry entry : object.entrySet()) {
                String key = (String)entry.getKey();
                if (classMapping.setters.containsKey(key)) continue;
                try {
                    classMapping.anySetter.invoke(t, key, this.toValue(null, (JsonValue)entry.getValue(), null, null, classMapping.anySetter.getGenericParameterTypes()[1], null, this.isDedup() ? new JsonPointerTracker(jsonPointer, (String)entry.getKey()) : null, type, MapperException::new));
                }
                catch (IllegalAccessException e5) {
                    throw new IllegalStateException(e5);
                }
                catch (InvocationTargetException e6) {
                    throw new MapperException(e6.getCause());
                }
            }
        } else if (classMapping.anyField != null) {
            try {
                classMapping.anyField.set(t, object.entrySet().stream().filter(it -> !classMapping.setters.containsKey(it.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> this.toValue(null, (JsonValue)e.getValue(), null, null, ((ParameterizedType)ParameterizedType.class.cast(classMapping.anyField.getGenericType())).getActualTypeArguments()[1], null, this.isDedup() ? new JsonPointerTracker(jsonPointer, (String)e.getKey()) : null, type, MapperException::new))));
            }
            catch (IllegalAccessException e7) {
                throw new IllegalStateException(e7);
            }
        }
        if (classMapping.mapAdder != null) {
            object.entrySet().stream().filter(it -> !classMapping.setters.containsKey(it.getKey())).filter(it -> ((JsonValue)it.getValue()).getValueType() != JsonValue.ValueType.NULL).forEach(e -> {
                Object convertedValue = this.toValue(null, (JsonValue)e.getValue(), null, null, classMapping.mapAdderType, null, new JsonPointerTracker(jsonPointer, (String)e.getKey()), inType, MapperException::new);
                if (convertedValue != null) {
                    try {
                        classMapping.mapAdder.invoke(t, e.getKey(), convertedValue);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IllegalStateException(ex);
                    }
                    catch (InvocationTargetException ex) {
                        throw new MapperException(ex.getCause());
                    }
                }
            });
        }
        return t;
    }

    private Number toNumberValue(JsonNumber jsonNumber) {
        if (jsonNumber.isIntegral()) {
            long longValue;
            int intValue = jsonNumber.intValue();
            if ((long)intValue == (longValue = jsonNumber.longValue())) {
                return intValue;
            }
            return longValue;
        }
        if (this.config.isUseBigDecimalForFloats()) {
            return jsonNumber.bigDecimalValue();
        }
        return jsonNumber.doubleValue();
    }

    private Object convertTo(Adapter converter, JsonValue jsonValue, JsonPointerTracker jsonPointer, Type targetType) {
        JsonValue.ValueType valueType = jsonValue != null ? jsonValue.getValueType() : null;
        AdapterKey key = this.getAdapterKey(converter);
        if (key != null && JsonValue.class == key.getTo()) {
            return converter.to(jsonValue);
        }
        if (JsonValue.ValueType.OBJECT == valueType) {
            Object param;
            if (JsonObject.class == key.getTo() || JsonStructure.class == key.getTo()) {
                return converter.to(jsonValue.asJsonObject());
            }
            try {
                Type to = key.getTo();
                param = this.buildObject(to, (JsonObject)JsonObject.class.cast(jsonValue), to instanceof Class, jsonPointer, this.getSkippedConverters());
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
            return converter.to(param);
        }
        if (JsonValue.ValueType.NULL.equals((Object)valueType)) {
            return null;
        }
        if (JsonValue.ValueType.STRING.equals((Object)valueType)) {
            if (key.getTo() == JsonString.class) {
                return converter.to(JsonString.class.cast(jsonValue));
            }
            return converter.to(((JsonString)JsonString.class.cast(jsonValue)).getString());
        }
        if ((JsonValue.ValueType.TRUE.equals((Object)valueType) || JsonValue.ValueType.FALSE.equals((Object)valueType)) && key != null && (Boolean.TYPE == key.getTo() || Boolean.class == key.getTo())) {
            return converter.to(Boolean.parseBoolean(jsonValue.toString()));
        }
        if (JsonValue.ValueType.NUMBER.equals((Object)valueType) && key != null) {
            if (Long.class == key.getTo() || Long.TYPE == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).longValue());
            }
            if (Integer.class == key.getTo() || Integer.TYPE == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).intValue());
            }
            if (Double.class == key.getTo() || Double.TYPE == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).doubleValue());
            }
            if (Float.class == key.getTo() || Float.TYPE == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).doubleValue());
            }
            if (BigInteger.class == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).bigIntegerValue());
            }
            if (BigDecimal.class == key.getTo() || Number.class == key.getTo()) {
                return converter.to(((JsonNumber)JsonNumber.class.cast(jsonValue)).bigDecimalValue());
            }
            if (JsonNumber.class == key.getTo()) {
                return converter.to(JsonNumber.class.cast(jsonValue));
            }
        }
        if (JsonValue.ValueType.ARRAY.equals((Object)valueType)) {
            TypeAwareAdapter adapter;
            if (JsonArray.class == key.getTo() || JsonStructure.class == key.getTo()) {
                return converter.to(jsonValue.asJsonObject());
            }
            if (TypeAwareAdapter.class.isInstance(converter) && (adapter = (TypeAwareAdapter)TypeAwareAdapter.class.cast(converter)).getFrom().equals(targetType)) {
                return converter.to(this.readObject(jsonValue, adapter.getTo()));
            }
            return this.buildArray(key.getTo(), jsonValue.asJsonArray(), null, null, jsonPointer, null);
        }
        return converter.to(jsonValue.toString());
    }

    private AdapterKey getAdapterKey(Adapter converter) {
        AdapterKey adapterKey = (AdapterKey)this.config.getReverseAdapters().get(converter);
        if (adapterKey == null) {
            if (converter instanceof TypeAwareAdapter) {
                return ((TypeAwareAdapter)TypeAwareAdapter.class.cast(converter)).getKey();
            }
            for (Class<?> current = converter.getClass(); current != null && current != Object.class; current = current.getSuperclass()) {
                Type[] types;
                for (Type t : types = current.getGenericInterfaces()) {
                    ParameterizedType pt;
                    if (!ParameterizedType.class.isInstance(t) || Adapter.class != (pt = (ParameterizedType)ParameterizedType.class.cast(t)).getRawType()) continue;
                    Type[] actualTypeArguments = pt.getActualTypeArguments();
                    adapterKey = new AdapterKey(actualTypeArguments[0], actualTypeArguments[1]);
                    this.config.getReverseAdapters().putIfAbsent(converter, adapterKey);
                    return adapterKey;
                }
            }
        }
        return adapterKey;
    }

    private Object toObject(Object baseInstance, JsonValue jsonValue, Type type, Adapter itemConverter, JsonPointerTracker jsonPointer, Type rootType) {
        if (jsonValue == null) {
            return null;
        }
        JsonValue.ValueType valueType = jsonValue.getValueType();
        if (JsonValue.ValueType.NULL == valueType) {
            return null;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            if (JsonValue.ValueType.TRUE == valueType) {
                return true;
            }
            if (JsonValue.ValueType.FALSE == valueType) {
                return false;
            }
            String snippet = this.config.getSnippet().of(jsonValue);
            String description = ExceptionMessages.description(valueType);
            throw new MapperException("Unable to parse " + description + " to boolean: " + snippet);
        }
        if (this.config.isTreatByteArrayAsBase64() && jsonValue.getValueType() == JsonValue.ValueType.STRING && type == byte[].class) {
            return Base64.getDecoder().decode(((JsonString)jsonValue).getString());
        }
        if (this.config.isTreatByteArrayAsBase64URL() && jsonValue.getValueType() == JsonValue.ValueType.STRING && type == byte[].class) {
            return Base64.getUrlDecoder().decode(((JsonString)jsonValue).getString());
        }
        if (Object.class == type) {
            if (JsonValue.ValueType.TRUE == valueType) {
                return true;
            }
            if (JsonValue.ValueType.FALSE == valueType) {
                return false;
            }
            if (JsonNumber.class.isInstance(jsonValue)) {
                return this.toNumberValue((JsonNumber)JsonNumber.class.cast(jsonValue));
            }
            if (JsonString.class.isInstance(jsonValue)) {
                return ((JsonString)JsonString.class.cast(jsonValue)).getString();
            }
        }
        if (type == Character.class || type == Character.TYPE) {
            return this.convertTo((Type)Class.class.cast(type), ((JsonString)JsonString.class.cast(jsonValue)).getString());
        }
        if (JsonObject.class.isInstance(jsonValue)) {
            boolean typedAdapter;
            if (JsonObject.class == type || JsonStructure.class == type || JsonValue.class == type) {
                return jsonValue;
            }
            boolean bl = typedAdapter = !ConverterAdapter.class.isInstance(itemConverter) && TypeAwareAdapter.class.isInstance(itemConverter);
            Object object = this.buildObject(baseInstance != null ? baseInstance.getClass() : (typedAdapter ? ((TypeAwareAdapter)TypeAwareAdapter.class.cast(itemConverter)).getTo() : type), (JsonObject)JsonObject.class.cast(jsonValue), type instanceof Class, jsonPointer, this.getSkippedConverters());
            return typedAdapter ? itemConverter.to(object) : object;
        }
        if (JsonArray.class.isInstance(jsonValue)) {
            if (JsonArray.class == type || JsonStructure.class == type || JsonValue.class == type) {
                return jsonValue;
            }
            return this.buildArray(type, (JsonArray)JsonArray.class.cast(jsonValue), itemConverter, null, jsonPointer, rootType);
        }
        if (JsonNumber.class.isInstance(jsonValue)) {
            if (JsonNumber.class == type || JsonValue.class == type) {
                return jsonValue;
            }
            JsonNumber number = (JsonNumber)JsonNumber.class.cast(jsonValue);
            if (type == Long.class || type == Long.TYPE) {
                return number.longValueExact();
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf((float)number.doubleValue());
            }
            if (type == Double.class || type == Double.TYPE) {
                return number.doubleValue();
            }
            if (type == BigInteger.class) {
                return number.bigIntegerValue();
            }
            if (type == BigDecimal.class || Number.class == type) {
                return number.bigDecimalValue();
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return number.intValueExact();
            }
            if (type == Short.class || type == Short.TYPE) {
                short shortVal;
                int intValue = number.intValue();
                if (intValue != (shortVal = (short)intValue)) {
                    throw new ArithmeticException("Overflow");
                }
                return shortVal;
            }
            if (type == Byte.class || type == Byte.TYPE) {
                int intValue = number.intValueExact();
                Validator.validateByte(intValue);
                return (byte)intValue;
            }
        } else if (JsonString.class.isInstance(jsonValue)) {
            if (JsonString.class == type || JsonValue.class == type) {
                return jsonValue;
            }
            String string = ((JsonString)JsonString.class.cast(jsonValue)).getString();
            if (itemConverter == null) {
                if (this.isDedup() && !String.class.equals((Object)type)) {
                    Object o;
                    Object object = o = this.jsonPointers == null ? null : this.jsonPointers.get(string);
                    if (o != null) {
                        return o;
                    }
                }
                return this.convertTo(type, string);
            }
            return itemConverter.to(string);
        }
        String snippet = this.config.getSnippet().of(jsonValue);
        String description = ExceptionMessages.description(valueType);
        throw new MapperException("Unable to parse " + description + " to " + type + ": " + snippet);
    }

    private Object buildArray(Type type, JsonArray jsonArray, Adapter itemConverter, ObjectConverter.Reader objectConverter, JsonPointerTracker jsonPointer, Type rootType) {
        Mappings.CollectionMapping mapping;
        if (Class.class.isInstance(type)) {
            Class clazz = (Class)Class.class.cast(type);
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                return this.buildArrayWithComponentType(jsonArray, componentType, itemConverter, jsonPointer, rootType);
            }
            if (Collection.class.isAssignableFrom(clazz) && (mapping = this.mappings.findCollectionMapping(new JohnzonParameterizedType(clazz, new Type[]{Object.class}), rootType)) != null) {
                return this.mapCollection(mapping, jsonArray, itemConverter, objectConverter, jsonPointer, rootType);
            }
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType genericType = (ParameterizedType)ParameterizedType.class.cast(type);
            if (Stream.class == genericType.getRawType()) {
                return Stream.of(Integer.valueOf(1)).flatMap(seed -> ((Collection)Collection.class.cast(this.buildArray(new JohnzonParameterizedType((Type)((Object)List.class), genericType.getActualTypeArguments()), jsonArray, itemConverter, objectConverter, jsonPointer, rootType))).stream());
            }
            mapping = this.mappings.findCollectionMapping(genericType, rootType);
            if (mapping != null) {
                return this.mapCollection(mapping, jsonArray, itemConverter, objectConverter, jsonPointer, rootType);
            }
        }
        if (GenericArrayType.class.isInstance(type)) {
            Type genericComponentType = ((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType();
            while (ParameterizedType.class.isInstance(genericComponentType)) {
                genericComponentType = ((ParameterizedType)ParameterizedType.class.cast(genericComponentType)).getRawType();
            }
            if (Class.class.isInstance(genericComponentType)) {
                return this.buildArrayWithComponentType(jsonArray, (Class)Class.class.cast(genericComponentType), itemConverter, jsonPointer, rootType);
            }
        }
        if (Object.class == type) {
            return this.buildArray(ANY_LIST, jsonArray, null, null, jsonPointer, rootType);
        }
        if (IntStream.class == type) {
            return Stream.of(Integer.valueOf(1)).flatMapToInt(seed -> IntStream.of((int[])int[].class.cast(this.buildArray((Type)((Object)int[].class), jsonArray, null, null, jsonPointer, rootType))));
        }
        if (LongStream.class == type) {
            return Stream.of(Integer.valueOf(1)).flatMapToLong(seed -> LongStream.of((long[])long[].class.cast(this.buildArray((Type)((Object)long[].class), jsonArray, null, null, jsonPointer, rootType))));
        }
        if (DoubleStream.class == type) {
            return Stream.of(Integer.valueOf(1)).flatMapToDouble(seed -> DoubleStream.of((double[])double[].class.cast(this.buildArray((Type)((Object)double[].class), jsonArray, null, null, jsonPointer, rootType))));
        }
        throw new UnsupportedOperationException("type " + type + " not supported");
    }

    private Object buildArrayWithComponentType(JsonArray jsonArray, Class<?> componentType, Adapter itemConverter, JsonPointerTracker jsonPointer, Type rootType) {
        if (Boolean.TYPE == componentType) {
            boolean[] array = new boolean[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                Object object = this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                if (object == null) {
                    throw new IllegalStateException("json array mapped to boolean[] has null value at index " + i);
                }
                array[i] = (Boolean)object;
                ++i;
            }
            return array;
        }
        if (Byte.TYPE == componentType) {
            byte[] array = new byte[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                Object object = this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                if (object == null) {
                    throw new IllegalStateException("json array mapped to byte[] has null value at index " + i);
                }
                array[i] = (Byte)object;
                ++i;
            }
            return array;
        }
        if (Character.TYPE == componentType) {
            char[] array = new char[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                Object object = this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                if (object == null) {
                    throw new IllegalStateException("json array mapped to char[] has null value at index " + i);
                }
                array[i] = ((Character)object).charValue();
                ++i;
            }
            return array;
        }
        if (Short.TYPE == componentType) {
            short[] array = new short[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                Object object = this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                if (object == null) {
                    throw new IllegalStateException("json array mapped to short[] has null value at index " + i);
                }
                array[i] = (Short)object;
                ++i;
            }
            return array;
        }
        if (Integer.TYPE == componentType) {
            int[] array = new int[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                Object object = this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                if (object == null) {
                    throw new IllegalStateException("json array mapped to int[] has null value at index " + i);
                }
                array[i] = (Integer)object;
                ++i;
            }
            return array;
        }
        if (Long.TYPE == componentType) {
            long[] array = new long[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                Object object = this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                if (object == null) {
                    throw new IllegalStateException("json array mapped to long[] has null value at index " + i);
                }
                array[i] = (Long)object;
                ++i;
            }
            return array;
        }
        if (Float.TYPE == componentType) {
            float[] array = new float[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                Object object = this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                if (object == null) {
                    throw new IllegalStateException("json array mapped to float[] has null value at index " + i);
                }
                array[i] = ((Float)object).floatValue();
                ++i;
            }
            return array;
        }
        if (Double.TYPE == componentType) {
            double[] array = new double[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                Object object = this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                if (object == null) {
                    throw new IllegalStateException("json array mapped to double[] has null value at index " + i);
                }
                array[i] = (Double)object;
                ++i;
            }
            return array;
        }
        if (Boolean.class == componentType) {
            Boolean[] array = new Boolean[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Boolean)this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Byte.class == componentType) {
            Byte[] array = new Byte[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Byte)this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Character.class == componentType) {
            Character[] array = new Character[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Character)this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Short.class == componentType) {
            Short[] array = new Short[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Short)this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Integer.class == componentType) {
            Integer[] array = new Integer[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Integer)this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Long.class == componentType) {
            Long[] array = new Long[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Long)this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Float.class == componentType) {
            Float[] array = new Float[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Float)this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        if (Double.class == componentType) {
            Double[] array = new Double[jsonArray.size()];
            int i = 0;
            for (JsonValue value : jsonArray) {
                array[i] = (Double)this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType);
                ++i;
            }
            return array;
        }
        Object array = Array.newInstance(componentType, jsonArray.size());
        int i = 0;
        for (JsonValue value : jsonArray) {
            Array.set(array, i, this.toObject(null, value, componentType, itemConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType));
            ++i;
        }
        return array;
    }

    private <T> Collection<T> mapCollection(Mappings.CollectionMapping mapping, JsonArray jsonArray, Adapter itemConverter, ObjectConverter.Reader objectConverter, JsonPointerTracker jsonPointer, Type rootType) {
        AbstractCollection collection;
        if (SortedSet.class == mapping.raw || NavigableSet.class == mapping.raw || TreeSet.class == mapping.raw) {
            collection = new TreeSet();
        } else if (Set.class == mapping.raw || HashSet.class == mapping.raw) {
            collection = new HashSet(jsonArray.size());
        } else if (Queue.class == mapping.raw || ArrayBlockingQueue.class == mapping.raw) {
            collection = new ArrayBlockingQueue(jsonArray.size());
        } else if (List.class == mapping.raw || Collection.class == mapping.raw || ArrayList.class == mapping.raw || EnumSet.class == mapping.raw) {
            collection = new ArrayList(jsonArray.size());
        } else if (LinkedHashSet.class == mapping.raw) {
            collection = new LinkedHashSet(jsonArray.size());
        } else if (LinkedList.class == mapping.raw) {
            collection = new LinkedList();
        } else if (Deque.class == mapping.raw || ArrayDeque.class == mapping.raw) {
            collection = new ArrayDeque(jsonArray.size());
        } else if (PriorityQueue.class == mapping.raw) {
            collection = new PriorityQueue(jsonArray.size());
        } else {
            throw new IllegalStateException("not supported collection type: " + mapping.raw.getName());
        }
        int i = 0;
        for (JsonValue value : jsonArray) {
            collection.add(JsonValue.NULL.equals(value) ? null : this.toValue(null, value, null, itemConverter, mapping.arg, objectConverter, this.isDedup() ? new JsonPointerTracker(jsonPointer, i) : null, rootType, MapperException::new));
            ++i;
        }
        if (EnumSet.class == mapping.raw) {
            if (!this.config.isSupportEnumContainerDeserialization()) {
                throw new MapperException("Enum container deserialization disabled, set supportEnumContainerDeserialization=true to enable it");
            }
            if (collection.isEmpty()) {
                return EnumSet.noneOf((Class)Class.class.cast(mapping.arg));
            }
            if (collection.size() == 1) {
                return (Collection)Collection.class.cast(EnumSet.of((Enum)Enum.class.cast(collection.iterator().next())));
            }
            List list = (List)List.class.cast(collection);
            return (Collection)Collection.class.cast(EnumSet.of((Enum)list.get(0), list.subList(1, list.size()).toArray(new Enum[list.size() - 1])));
        }
        return collection;
    }

    private Object[] createParameters(Mappings.ClassMapping mapping, JsonObject object, JsonPointerTracker jsonPointer, Function<Exception, RuntimeException> onException) {
        int length = mapping.factory.getParameterTypes().length;
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            String paramName = mapping.factory.getParameterNames()[i];
            Type parameterType = mapping.factory.getParameterTypes()[i];
            objects[i] = this.toValue(null, (JsonValue)object.get(paramName), mapping.factory.getParameterConverter()[i], mapping.factory.getParameterItemConverter()[i], parameterType, mapping.factory.getObjectConverter()[i], this.isDedup() ? new JsonPointerTracker(jsonPointer, paramName) : null, mapping.clazz, onException);
            if (objects[i] != null) continue;
            objects[i] = Mappings.getPrimitiveDefault(parameterType);
        }
        return objects;
    }

    private Object toValue(Object baseInstance, JsonValue jsonValue, Adapter converter, Adapter itemConverter, Type type, ObjectConverter.Reader objectConverter, JsonPointerTracker jsonPointer, Type rootType, Function<Exception, RuntimeException> onException) {
        if (objectConverter != null) {
            return objectConverter.fromJson(jsonValue, type, this);
        }
        try {
            return converter == null ? this.toObject(baseInstance, jsonValue, type, itemConverter, jsonPointer, rootType) : this.convertTo(converter, jsonValue, jsonPointer, type);
        }
        catch (Exception e) {
            if (e instanceof MapperException) {
                throw e;
            }
            throw onException.apply(e);
        }
    }

    private Object convertTo(Type aClass, String text) {
        if (Object.class == aClass || String.class == aClass) {
            return text;
        }
        Adapter converter = this.findAdapter(aClass);
        Method method = (Method)this.valueOfs.get(aClass);
        if (method == null && Class.class.isInstance(aClass)) {
            Class cast = (Class)Class.class.cast(aClass);
            try {
                method = cast.getMethod("valueOf", String.class);
                if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                    this.valueOfs.putIfAbsent(cast, method);
                } else {
                    method = null;
                }
            }
            catch (NoSuchMethodException e) {
                if (Character.TYPE == aClass) {
                    return CHARACTER_CONVERTER.fromString(text);
                }
                try {
                    return this.convertTo((Type)Class.class.cast(cast.getField("TYPE").get(null)), text);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (method != null) {
            try {
                return method.invoke(null, text);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new MapperException(e.getCause());
            }
        }
        if (converter == null) {
            if (ParameterizedType.class.isInstance(aClass)) {
                return this.convertTo(((ParameterizedType)ParameterizedType.class.cast(aClass)).getRawType(), text);
            }
            throw new MapperException("Missing a Converter for type " + aClass + " to convert the JSON String '" + text + "' . Please register a custom converter for it.");
        }
        return converter.to(text);
    }

    private Adapter findAdapter(Type aClass) {
        Class clazz;
        if (this.config.getNoParserAdapterTypes().contains(aClass)) {
            return null;
        }
        Object converter = this.config.getAdapters().get(new AdapterKey(aClass, (Type)((Object)String.class), true));
        if (converter != null) {
            return converter;
        }
        if (Class.class.isInstance(aClass) && Enum.class.isAssignableFrom(clazz = (Class)Class.class.cast(aClass))) {
            ConverterAdapter enumConverter = new ConverterAdapter(this.config.getEnumConverterFactory().apply(clazz), clazz);
            this.config.getAdapters().putIfAbsent(new AdapterKey((Type)((Object)String.class), aClass), enumConverter);
            return enumConverter;
        }
        List matched = this.config.getAdapters().adapterKeys().stream().filter(k -> k.isAssignableFrom(aClass)).collect(Collectors.toList());
        if (matched.size() == 1) {
            Object adapter = this.config.getAdapters().get(matched.iterator().next());
            if (TypeAwareAdapter.class.isInstance(adapter)) {
                this.config.getAdapters().put(new AdapterKey(aClass, ((TypeAwareAdapter)TypeAwareAdapter.class.cast(adapter)).getTo()), adapter);
            }
            return adapter;
        }
        this.config.getNoParserAdapterTypes().add(aClass);
        return null;
    }

    private static class SuppressConversionMappingParser
    implements MappingParser {
        private final MappingParserImpl delegate;
        private final JsonObject suppressConversionFor;
        private final Collection<Class<?>> skippedConverters;

        public SuppressConversionMappingParser(MappingParserImpl delegate, JsonObject suppressConversionFor, Collection<Class<?>> skippedConverters) {
            this.delegate = delegate;
            this.suppressConversionFor = suppressConversionFor;
            this.skippedConverters = skippedConverters;
        }

        @Override
        public Collection<Class<?>> getSkippedConverters() {
            return this.skippedConverters;
        }

        @Override
        public <T> T readObject(Type targetType) {
            return this.delegate.readObject(targetType);
        }

        @Override
        public <T> T readObject(JsonValue jsonValue, Type targetType) {
            Collection<Class<?>> skippedConverters = this.getSkippedConverters();
            if (this.suppressConversionFor == jsonValue) {
                return this.delegate.readObject(jsonValue, targetType, false, skippedConverters);
            }
            boolean useConverters = Class.class.isInstance(targetType) && (skippedConverters == null || skippedConverters.stream().noneMatch(it -> it.isAssignableFrom((Class)Class.class.cast(targetType)))) || ParameterizedType.class.isInstance(targetType);
            return this.delegate.readObject(jsonValue, targetType, useConverters, skippedConverters);
        }
    }
}

