/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.JsonUtil;
import com.bazaarvoice.jolt.exception.JsonMarshalException;
import com.bazaarvoice.jolt.exception.JsonUnmarshalException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonUtilImpl
implements JsonUtil {
    private final ObjectMapper objectMapper;
    private final ObjectWriter prettyPrintWriter;
    public static final String DEFAULT_ENCODING_UTF_8 = "utf-8";
    private static final TypeReference<Map<String, Object>> mapTypeReference = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<List<Object>> listTypeReference = new TypeReference<List<Object>>(){};

    public static void configureStockJoltObjectMapper(ObjectMapper objectMapper) {
        SimpleModule stockModule = new SimpleModule("stockJoltMapping", new Version(1, 0, 0, null, null, null)).addAbstractTypeMapping(Map.class, LinkedHashMap.class);
        objectMapper.registerModule(stockModule);
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }

    public JsonUtilImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper == null ? new ObjectMapper() : objectMapper;
        JsonUtilImpl.configureStockJoltObjectMapper(this.objectMapper);
        this.prettyPrintWriter = this.objectMapper.writerWithDefaultPrettyPrinter();
    }

    public JsonUtilImpl() {
        this(new ObjectMapper());
    }

    @Override
    public Object jsonToObject(String json) {
        return this.jsonToObject(json, DEFAULT_ENCODING_UTF_8);
    }

    @Override
    public Object jsonToObject(String json, String charset) {
        try {
            return this.jsonToObject(new ByteArrayInputStream(json.getBytes(charset)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object jsonToObject(InputStream in) {
        try {
            return this.objectMapper.readValue(in, Object.class);
        }
        catch (IOException e) {
            throw new JsonUnmarshalException("Unable to unmarshal JSON to an Object.", e);
        }
    }

    @Override
    public Map<String, Object> jsonToMap(String json) {
        return this.jsonToMap(json, DEFAULT_ENCODING_UTF_8);
    }

    @Override
    public Map<String, Object> jsonToMap(String json, String charset) {
        try {
            return this.jsonToMap(new ByteArrayInputStream(json.getBytes(charset)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> jsonToMap(InputStream in) {
        try {
            return this.objectMapper.readValue(in, mapTypeReference);
        }
        catch (IOException e) {
            throw new JsonUnmarshalException("Unable to unmarshal JSON to a Map.", e);
        }
    }

    @Override
    public List<Object> jsonToList(String json) {
        return this.jsonToList(json, DEFAULT_ENCODING_UTF_8);
    }

    @Override
    public List<Object> jsonToList(String json, String charset) {
        try {
            return this.jsonToList(new ByteArrayInputStream(json.getBytes(charset)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Object> jsonToList(InputStream in) {
        try {
            return this.objectMapper.readValue(in, listTypeReference);
        }
        catch (IOException e) {
            throw new JsonUnmarshalException("Unable to unmarshal JSON to a List.", e);
        }
    }

    @Override
    public Object filepathToObject(String filePath) {
        try {
            FileInputStream fileInputStream = new FileInputStream(filePath);
            return this.jsonToObject(fileInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load JSON file from: " + filePath);
        }
    }

    @Override
    public Map<String, Object> filepathToMap(String filePath) {
        try {
            FileInputStream fileInputStream = new FileInputStream(filePath);
            return this.jsonToMap(fileInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load JSON file from: " + filePath);
        }
    }

    @Override
    public List<Object> filepathToList(String filePath) {
        try {
            FileInputStream fileInputStream = new FileInputStream(filePath);
            return this.jsonToList(fileInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load JSON file from: " + filePath);
        }
    }

    @Override
    public Object classpathToObject(String classPath) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(classPath);
            return this.jsonToObject(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load JSON object from classPath : " + classPath, e);
        }
    }

    @Override
    public Map<String, Object> classpathToMap(String classPath) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(classPath);
            return this.jsonToMap(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load JSON map from classPath : " + classPath, e);
        }
    }

    @Override
    public List<Object> classpathToList(String classPath) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(classPath);
            return this.jsonToList(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load JSON map from classPath : " + classPath, e);
        }
    }

    @Override
    @Deprecated
    public <T> T jsonTo(InputStream in, TypeReference<T> typeRef) {
        return this.streamToType(in, typeRef);
    }

    @Override
    @Deprecated
    public <T> T jsonTo(String json, TypeReference<T> typeRef) {
        return this.streamToType((InputStream)new ByteArrayInputStream(json.getBytes()), typeRef);
    }

    @Override
    public <T> T stringToType(String json, TypeReference<T> typeRef) {
        return this.streamToType((InputStream)new ByteArrayInputStream(json.getBytes()), typeRef);
    }

    @Override
    public <T> T stringToType(String json, Class<T> aClass) {
        return this.streamToType((InputStream)new ByteArrayInputStream(json.getBytes()), aClass);
    }

    @Override
    public <T> T classpathToType(String classPath, TypeReference<T> typeRef) {
        return this.streamToType(this.getClass().getResourceAsStream(classPath), typeRef);
    }

    @Override
    public <T> T classpathToType(String classPath, Class<T> aClass) {
        return this.streamToType(this.getClass().getResourceAsStream(classPath), aClass);
    }

    @Override
    public <T> T fileToType(String filePath, TypeReference<T> typeRef) {
        try {
            FileInputStream fileInputStream = new FileInputStream(filePath);
            return this.streamToType((InputStream)fileInputStream, typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load JSON file from: " + filePath);
        }
    }

    @Override
    public <T> T fileToType(String filePath, Class<T> aClass) {
        try {
            FileInputStream fileInputStream = new FileInputStream(filePath);
            return this.streamToType((InputStream)fileInputStream, aClass);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load JSON file from: " + filePath);
        }
    }

    @Override
    public <T> T streamToType(InputStream in, TypeReference<T> typeRef) {
        try {
            return this.objectMapper.readValue(in, typeRef);
        }
        catch (IOException e) {
            throw new JsonUnmarshalException("Unable to unmarshal JSON to type: " + typeRef, e);
        }
    }

    @Override
    public <T> T streamToType(InputStream in, Class<T> aClass) {
        try {
            return this.objectMapper.readValue(in, aClass);
        }
        catch (IOException e) {
            throw new JsonUnmarshalException("Unable to unmarshal JSON to class: " + aClass, e);
        }
    }

    @Override
    public String toJsonString(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new JsonMarshalException("Unable to serialize object : " + obj, e);
        }
    }

    @Override
    public String toPrettyJsonString(Object obj) {
        try {
            return this.prettyPrintWriter.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new JsonMarshalException("Unable to serialize object : " + obj, e);
        }
    }

    @Override
    public Object cloneJson(Object obj) {
        String string = this.toJsonString(obj);
        return this.jsonToObject(string);
    }
}

