/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.removr.spec;

import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.pathelement.PathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarDoublePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarRegexPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarSinglePathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.List;
import java.util.Map;

public abstract class RemovrSpec {
    protected final MatchablePathElement pathElement;

    public RemovrSpec(String rawJsonKey) {
        PathElement pathElement = RemovrSpec.parse(rawJsonKey);
        if (!(pathElement instanceof MatchablePathElement)) {
            throw new SpecException("Spec LHS key=" + rawJsonKey + " is not a valid LHS key.");
        }
        this.pathElement = (MatchablePathElement)pathElement;
    }

    public static PathElement parse(String key) {
        if ("*".equals(key)) {
            return new StarAllPathElement(key);
        }
        int numOfStars = StringTools.countMatches(key, "*");
        if (numOfStars == 1) {
            return new StarSinglePathElement(key);
        }
        if (numOfStars == 2) {
            return new StarDoublePathElement(key);
        }
        if (numOfStars > 2) {
            return new StarRegexPathElement(key);
        }
        return new LiteralPathElement(key);
    }

    protected Integer getNonNegativeIntegerFromLiteralPathElement() {
        Integer pathElementInt = null;
        try {
            pathElementInt = Integer.parseInt(this.pathElement.getRawKey());
            if (pathElementInt < 0) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return pathElementInt;
    }

    public abstract List<Integer> applyToList(List<Object> var1);

    public abstract List<String> applyToMap(Map<String, Object> var1);
}

