/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jolt;

import com.bazaarvoice.jolt.Transform;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jolt.JoltEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;

@Component(value="jolt")
public class JoltComponent
extends DefaultComponent {
    @Metadata(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @Metadata(label="advanced")
    private Transform transform;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        JoltEndpoint answer = new JoltEndpoint(uri, this, remaining);
        answer.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        answer.setContentCache(cache);
        answer.setTransform(this.transform);
        if (ResourceHelper.isHttpUri(remaining)) {
            remaining = ResourceHelper.appendParameters(remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }
}

