/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jolt;

import org.apache.camel.CamelContext;
import org.apache.camel.component.jolt.JoltEndpoint;
import org.apache.camel.component.jolt.JoltInputOutputType;
import org.apache.camel.component.jolt.JoltTransformType;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class JoltEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JoltEndpoint target = (JoltEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                target.setAllowContextMapAll(JoltEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                target.setAllowTemplateFromHeader(JoltEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "contentcache": 
            case "contentCache": {
                target.setContentCache(JoltEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "inputtype": 
            case "inputType": {
                target.setInputType(JoltEndpointConfigurer.property(camelContext, JoltInputOutputType.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(JoltEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "outputtype": 
            case "outputType": {
                target.setOutputType(JoltEndpointConfigurer.property(camelContext, JoltInputOutputType.class, value));
                return true;
            }
            case "transformdsl": 
            case "transformDsl": {
                target.setTransformDsl(JoltEndpointConfigurer.property(camelContext, JoltTransformType.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                return Boolean.TYPE;
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                return Boolean.TYPE;
            }
            case "contentcache": 
            case "contentCache": {
                return Boolean.TYPE;
            }
            case "inputtype": 
            case "inputType": {
                return JoltInputOutputType.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "outputtype": 
            case "outputType": {
                return JoltInputOutputType.class;
            }
            case "transformdsl": 
            case "transformDsl": {
                return JoltTransformType.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JoltEndpoint target = (JoltEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                return target.isAllowContextMapAll();
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                return target.isAllowTemplateFromHeader();
            }
            case "contentcache": 
            case "contentCache": {
                return target.isContentCache();
            }
            case "inputtype": 
            case "inputType": {
                return target.getInputType();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "outputtype": 
            case "outputType": {
                return target.getOutputType();
            }
            case "transformdsl": 
            case "transformDsl": {
                return target.getTransformDsl();
            }
        }
        return null;
    }
}

